// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A helper object used by the dice web signin intercept bubble to
 * interact with the browser.
 */
import { sendWithPromise } from 'chrome://resources/js/cr.js';
export class DiceWebSigninInterceptBrowserProxyImpl {
    accept() {
        chrome.send('accept');
    }
    cancel() {
        chrome.send('cancel');
    }
    pageLoaded() {
        return sendWithPromise('pageLoaded');
    }
    chromeSigninPageLoaded() {
        return sendWithPromise('chromeSigninPageLoaded');
    }
    initializedWithHeight(height) {
        chrome.send('initializedWithHeight', [height]);
    }
    static getInstance() {
        return instance ||
            (instance = new DiceWebSigninInterceptBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
