// chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ClickModifiersSpec as ui_mojom_ClickModifiersSpec,
  ClickModifiers as ui_mojom_ClickModifiers
} from '//resources/mojo/ui/base/mojom/window_open_disposition.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const CurrentPageActionButtonStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CurrentPageActionButtonState {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kAdd = 0,
  kDisabled = 1,
  kMarkAsRead = 2,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'reading_list.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "reading_list.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'reading_list.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getReadLaterEntries(): Promise<{
        entries: ReadLaterEntriesByStatus, }>;
  openURL(url: url_mojom_Url, markAsRead: boolean, clickModifiers: ui_mojom_ClickModifiers): void;
  updateReadStatus(url: url_mojom_Url, read: boolean): void;
  markCurrentTabAsRead(): void;
  addCurrentTab(): void;
  removeEntry(url: url_mojom_Url): void;
  showContextMenuForURL(url: url_mojom_Url, x: number, y: number): void;
  updateCurrentPageActionButtonState(): void;
  showUI(): void;
  closeUI(): void;
  getWindowData(): Promise<{
        windows: Window[], }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getReadLaterEntries(): Promise<{
        entries: ReadLaterEntriesByStatus, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetReadLaterEntries_ParamsSpec.$,
        PageHandler_GetReadLaterEntries_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  openURL(
      url: url_mojom_Url,
      markAsRead: boolean,
      clickModifiers: ui_mojom_ClickModifiers): void {
    this.proxy.sendMessage(
        1,
        PageHandler_OpenURL_ParamsSpec.$,
        null,
        [
          url,
          markAsRead,
          clickModifiers
        ],
        false);
  }

  updateReadStatus(
      url: url_mojom_Url,
      read: boolean): void {
    this.proxy.sendMessage(
        2,
        PageHandler_UpdateReadStatus_ParamsSpec.$,
        null,
        [
          url,
          read
        ],
        false);
  }

  markCurrentTabAsRead(): void {
    this.proxy.sendMessage(
        3,
        PageHandler_MarkCurrentTabAsRead_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  addCurrentTab(): void {
    this.proxy.sendMessage(
        4,
        PageHandler_AddCurrentTab_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  removeEntry(
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        5,
        PageHandler_RemoveEntry_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  showContextMenuForURL(
      url: url_mojom_Url,
      x: number,
      y: number): void {
    this.proxy.sendMessage(
        6,
        PageHandler_ShowContextMenuForURL_ParamsSpec.$,
        null,
        [
          url,
          x,
          y
        ],
        false);
  }

  updateCurrentPageActionButtonState(): void {
    this.proxy.sendMessage(
        7,
        PageHandler_UpdateCurrentPageActionButtonState_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  showUI(): void {
    this.proxy.sendMessage(
        8,
        PageHandler_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  closeUI(): void {
    this.proxy.sendMessage(
        9,
        PageHandler_CloseUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getWindowData(): Promise<{
        windows: Window[], }> {
    return this.proxy.sendMessage(
        10,
        PageHandler_GetWindowData_ParamsSpec.$,
        PageHandler_GetWindowData_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetReadLaterEntries_ParamsSpec.$,
        PageHandler_GetReadLaterEntries_ResponseParamsSpec.$,
        impl.getReadLaterEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_OpenURL_ParamsSpec.$,
        null,
        impl.openURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_UpdateReadStatus_ParamsSpec.$,
        null,
        impl.updateReadStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_MarkCurrentTabAsRead_ParamsSpec.$,
        null,
        impl.markCurrentTabAsRead.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_AddCurrentTab_ParamsSpec.$,
        null,
        impl.addCurrentTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_RemoveEntry_ParamsSpec.$,
        null,
        impl.removeEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_ShowContextMenuForURL_ParamsSpec.$,
        null,
        impl.showContextMenuForURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_UpdateCurrentPageActionButtonState_ParamsSpec.$,
        null,
        impl.updateCurrentPageActionButtonState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetWindowData_ParamsSpec.$,
        PageHandler_GetWindowData_ResponseParamsSpec.$,
        impl.getWindowData.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "reading_list.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getReadLaterEntries: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openURL: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateReadStatus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  markCurrentTabAsRead: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addCurrentTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeEntry: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showContextMenuForURL: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateCurrentPageActionButtonState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getWindowData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getReadLaterEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetReadLaterEntries_ParamsSpec.$,
        PageHandler_GetReadLaterEntries_ResponseParamsSpec.$,
        this.getReadLaterEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_OpenURL_ParamsSpec.$,
        null,
        this.openURL.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateReadStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_UpdateReadStatus_ParamsSpec.$,
        null,
        this.updateReadStatus.createReceiverHandler(false /* expectsResponse */),
        false);
    this.markCurrentTabAsRead =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_MarkCurrentTabAsRead_ParamsSpec.$,
        null,
        this.markCurrentTabAsRead.createReceiverHandler(false /* expectsResponse */),
        false);
    this.addCurrentTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_AddCurrentTab_ParamsSpec.$,
        null,
        this.addCurrentTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.removeEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_RemoveEntry_ParamsSpec.$,
        null,
        this.removeEntry.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showContextMenuForURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_ShowContextMenuForURL_ParamsSpec.$,
        null,
        this.showContextMenuForURL.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateCurrentPageActionButtonState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_UpdateCurrentPageActionButtonState_ParamsSpec.$,
        null,
        this.updateCurrentPageActionButtonState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getWindowData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetWindowData_ParamsSpec.$,
        PageHandler_GetWindowData_ResponseParamsSpec.$,
        this.getWindowData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'reading_list.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  itemsChanged(entries: ReadLaterEntriesByStatus): void;
  currentPageActionButtonStateChanged(state: CurrentPageActionButtonState): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  itemsChanged(
      entries: ReadLaterEntriesByStatus): void {
    this.proxy.sendMessage(
        0,
        Page_ItemsChanged_ParamsSpec.$,
        null,
        [
          entries
        ],
        false);
  }

  currentPageActionButtonStateChanged(
      state: CurrentPageActionButtonState): void {
    this.proxy.sendMessage(
        1,
        Page_CurrentPageActionButtonStateChanged_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_ItemsChanged_ParamsSpec.$,
        null,
        impl.itemsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_CurrentPageActionButtonStateChanged_ParamsSpec.$,
        null,
        impl.currentPageActionButtonStateChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "reading_list.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  itemsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  currentPageActionButtonStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.itemsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_ItemsChanged_ParamsSpec.$,
        null,
        this.itemsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.currentPageActionButtonStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_CurrentPageActionButtonStateChanged_ParamsSpec.$,
        null,
        this.currentPageActionButtonStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ReadLaterEntriesByStatusSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ReadLaterEntrySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WindowSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetReadLaterEntries_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetReadLaterEntries_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenURL_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UpdateReadStatus_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_MarkCurrentTabAsRead_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AddCurrentTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveEntry_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowContextMenuForURL_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UpdateCurrentPageActionButtonState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CloseUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetWindowData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetWindowData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ItemsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_CurrentPageActionButtonStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ReadLaterEntriesByStatusMojoType {
  unreadEntries: ReadLaterEntry[];
  readEntries: ReadLaterEntry[];
}


export type ReadLaterEntriesByStatus = ReadLaterEntriesByStatusMojoType;
mojo.internal.Struct<ReadLaterEntriesByStatusMojoType>(
    ReadLaterEntriesByStatusSpec.$,
    'ReadLaterEntriesByStatus',
    [
      mojo.internal.StructField<ReadLaterEntriesByStatusMojoType, ReadLaterEntry[]>(
        'unreadEntries', 0,
        0,
        mojo.internal.Array(ReadLaterEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadLaterEntriesByStatusMojoType, ReadLaterEntry[]>(
        'readEntries', 8,
        0,
        mojo.internal.Array(ReadLaterEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ReadLaterEntryMojoType {
  title: string;
  url: url_mojom_Url;
  displayUrl: string;
  updateTime: bigint;
  read: boolean;
  displayTimeSinceUpdate: string;
}


export type ReadLaterEntry = ReadLaterEntryMojoType;
mojo.internal.Struct<ReadLaterEntryMojoType>(
    ReadLaterEntrySpec.$,
    'ReadLaterEntry',
    [
      mojo.internal.StructField<ReadLaterEntryMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadLaterEntryMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadLaterEntryMojoType, string>(
        'displayUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadLaterEntryMojoType, bigint>(
        'updateTime', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadLaterEntryMojoType, boolean>(
        'read', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ReadLaterEntryMojoType, string>(
        'displayTimeSinceUpdate', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface WindowMojoType {
  active: boolean;
  height: number;
}


export type Window = WindowMojoType;
mojo.internal.Struct<WindowMojoType>(
    WindowSpec.$,
    'Window',
    [
      mojo.internal.StructField<WindowMojoType, boolean>(
        'active', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WindowMojoType, number>(
        'height', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetReadLaterEntries_ParamsMojoType {
}


export type PageHandler_GetReadLaterEntries_Params = PageHandler_GetReadLaterEntries_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetReadLaterEntries_ParamsMojoType>(
    PageHandler_GetReadLaterEntries_ParamsSpec.$,
    'PageHandler_GetReadLaterEntries_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetReadLaterEntries_ResponseParamsMojoType {
  entries: ReadLaterEntriesByStatus;
}


export type PageHandler_GetReadLaterEntries_ResponseParams = PageHandler_GetReadLaterEntries_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetReadLaterEntries_ResponseParamsMojoType>(
    PageHandler_GetReadLaterEntries_ResponseParamsSpec.$,
    'PageHandler_GetReadLaterEntries_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetReadLaterEntries_ResponseParamsMojoType, ReadLaterEntriesByStatus>(
        'entries', 0,
        0,
        ReadLaterEntriesByStatusSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenURL_ParamsMojoType {
  url: url_mojom_Url;
  markAsRead: boolean;
  clickModifiers: ui_mojom_ClickModifiers;
}


export type PageHandler_OpenURL_Params = PageHandler_OpenURL_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenURL_ParamsMojoType>(
    PageHandler_OpenURL_ParamsSpec.$,
    'PageHandler_OpenURL_Params',
    [
      mojo.internal.StructField<PageHandler_OpenURL_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenURL_ParamsMojoType, boolean>(
        'markAsRead', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenURL_ParamsMojoType, ui_mojom_ClickModifiers>(
        'clickModifiers', 16,
        0,
        ui_mojom_ClickModifiersSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_UpdateReadStatus_ParamsMojoType {
  url: url_mojom_Url;
  read: boolean;
}


export type PageHandler_UpdateReadStatus_Params = PageHandler_UpdateReadStatus_ParamsMojoType;
mojo.internal.Struct<PageHandler_UpdateReadStatus_ParamsMojoType>(
    PageHandler_UpdateReadStatus_ParamsSpec.$,
    'PageHandler_UpdateReadStatus_Params',
    [
      mojo.internal.StructField<PageHandler_UpdateReadStatus_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_UpdateReadStatus_ParamsMojoType, boolean>(
        'read', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_MarkCurrentTabAsRead_ParamsMojoType {
}


export type PageHandler_MarkCurrentTabAsRead_Params = PageHandler_MarkCurrentTabAsRead_ParamsMojoType;
mojo.internal.Struct<PageHandler_MarkCurrentTabAsRead_ParamsMojoType>(
    PageHandler_MarkCurrentTabAsRead_ParamsSpec.$,
    'PageHandler_MarkCurrentTabAsRead_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_AddCurrentTab_ParamsMojoType {
}


export type PageHandler_AddCurrentTab_Params = PageHandler_AddCurrentTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_AddCurrentTab_ParamsMojoType>(
    PageHandler_AddCurrentTab_ParamsSpec.$,
    'PageHandler_AddCurrentTab_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RemoveEntry_ParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_RemoveEntry_Params = PageHandler_RemoveEntry_ParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveEntry_ParamsMojoType>(
    PageHandler_RemoveEntry_ParamsSpec.$,
    'PageHandler_RemoveEntry_Params',
    [
      mojo.internal.StructField<PageHandler_RemoveEntry_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShowContextMenuForURL_ParamsMojoType {
  url: url_mojom_Url;
  x: number;
  y: number;
}


export type PageHandler_ShowContextMenuForURL_Params = PageHandler_ShowContextMenuForURL_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowContextMenuForURL_ParamsMojoType>(
    PageHandler_ShowContextMenuForURL_ParamsSpec.$,
    'PageHandler_ShowContextMenuForURL_Params',
    [
      mojo.internal.StructField<PageHandler_ShowContextMenuForURL_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ShowContextMenuForURL_ParamsMojoType, number>(
        'x', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ShowContextMenuForURL_ParamsMojoType, number>(
        'y', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_UpdateCurrentPageActionButtonState_ParamsMojoType {
}


export type PageHandler_UpdateCurrentPageActionButtonState_Params = PageHandler_UpdateCurrentPageActionButtonState_ParamsMojoType;
mojo.internal.Struct<PageHandler_UpdateCurrentPageActionButtonState_ParamsMojoType>(
    PageHandler_UpdateCurrentPageActionButtonState_ParamsSpec.$,
    'PageHandler_UpdateCurrentPageActionButtonState_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_ShowUI_ParamsMojoType {
}


export type PageHandler_ShowUI_Params = PageHandler_ShowUI_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowUI_ParamsMojoType>(
    PageHandler_ShowUI_ParamsSpec.$,
    'PageHandler_ShowUI_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_CloseUI_ParamsMojoType {
}


export type PageHandler_CloseUI_Params = PageHandler_CloseUI_ParamsMojoType;
mojo.internal.Struct<PageHandler_CloseUI_ParamsMojoType>(
    PageHandler_CloseUI_ParamsSpec.$,
    'PageHandler_CloseUI_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetWindowData_ParamsMojoType {
}


export type PageHandler_GetWindowData_Params = PageHandler_GetWindowData_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetWindowData_ParamsMojoType>(
    PageHandler_GetWindowData_ParamsSpec.$,
    'PageHandler_GetWindowData_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetWindowData_ResponseParamsMojoType {
  windows: Window[];
}


export type PageHandler_GetWindowData_ResponseParams = PageHandler_GetWindowData_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetWindowData_ResponseParamsMojoType>(
    PageHandler_GetWindowData_ResponseParamsSpec.$,
    'PageHandler_GetWindowData_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetWindowData_ResponseParamsMojoType, Window[]>(
        'windows', 0,
        0,
        mojo.internal.Array(WindowSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ItemsChanged_ParamsMojoType {
  entries: ReadLaterEntriesByStatus;
}


export type Page_ItemsChanged_Params = Page_ItemsChanged_ParamsMojoType;
mojo.internal.Struct<Page_ItemsChanged_ParamsMojoType>(
    Page_ItemsChanged_ParamsSpec.$,
    'Page_ItemsChanged_Params',
    [
      mojo.internal.StructField<Page_ItemsChanged_ParamsMojoType, ReadLaterEntriesByStatus>(
        'entries', 0,
        0,
        ReadLaterEntriesByStatusSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_CurrentPageActionButtonStateChanged_ParamsMojoType {
  state: CurrentPageActionButtonState;
}


export type Page_CurrentPageActionButtonStateChanged_Params = Page_CurrentPageActionButtonStateChanged_ParamsMojoType;
mojo.internal.Struct<Page_CurrentPageActionButtonStateChanged_ParamsMojoType>(
    Page_CurrentPageActionButtonStateChanged_ParamsSpec.$,
    'Page_CurrentPageActionButtonStateChanged_Params',
    [
      mojo.internal.StructField<Page_CurrentPageActionButtonStateChanged_ParamsMojoType, CurrentPageActionButtonState>(
        'state', 0,
        0,
        CurrentPageActionButtonStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



