import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/icons.html.js';
import '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import './language_menu.js';
import type { CrActionMenuElement } from '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderLitElement } from '//resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { LanguageMenuElement } from './language_menu.js';
import type { VoiceNotificationListener } from './read_aloud/voice_notification_manager.js';
import { NotificationType } from './read_aloud/voice_language_conversions.js';
export interface VoiceSelectionMenuElement {
    $: {
        voiceSelectionMenu: CrLazyRenderLitElement<CrActionMenuElement>;
        languageMenu: LanguageMenuElement;
    };
}
interface VoiceDropdownGroup {
    language: string;
    voices: VoiceDropdownItem[];
}
interface VoiceDropdownItem {
    title: string;
    voice: SpeechSynthesisVoice;
    selected: boolean;
    previewInitiated: boolean;
    previewActuallyPlaying: boolean;
    id: string;
}
declare const VoiceSelectionMenuElementBase: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin_lit.js").WebUiListenerMixinLitInterface);
export declare class VoiceSelectionMenuElement extends VoiceSelectionMenuElementBase implements VoiceNotificationListener {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        selectedVoice: {
            type: ObjectConstructor;
        };
        availableVoices: {
            type: ArrayConstructor;
        };
        enabledLangs: {
            type: ArrayConstructor;
        };
        previewVoicePlaying: {
            type: ObjectConstructor;
        };
        currentNotifications_: {
            type: ObjectConstructor;
        };
        previewVoiceInitiated: {
            type: ObjectConstructor;
        };
        localeToDisplayName: {
            type: ObjectConstructor;
        };
        showLanguageMenuDialog_: {
            type: BooleanConstructor;
        };
        downloadingMessages_: {
            type: BooleanConstructor;
        };
        voiceGroups_: {
            type: ObjectConstructor;
        };
    };
    accessor selectedVoice: SpeechSynthesisVoice | undefined;
    accessor localeToDisplayName: {
        [lang: string]: string;
    };
    accessor previewVoicePlaying: SpeechSynthesisVoice | null;
    accessor enabledLangs: string[];
    accessor availableVoices: SpeechSynthesisVoice[];
    private accessor currentNotifications_;
    private accessor previewVoiceInitiated;
    protected errorMessages_: string[];
    protected accessor downloadingMessages_: string[];
    protected accessor voiceGroups_: VoiceDropdownGroup[];
    protected accessor showLanguageMenuDialog_: boolean;
    private readonly spBodyPadding_;
    private logger_;
    private notificationManager_;
    willUpdate(changedProperties: PropertyValues<this>): void;
    notify(type: NotificationType, language?: string): void;
    onVoiceSelectionMenuClick(targetElement: HTMLElement): void;
    private onMenuShown;
    protected voiceItemTabIndex_(groupIndex: number, voiceIndex: number): -1 | 0;
    private computeEnabledVoices_;
    private getLangDisplayName;
    private computeVoiceDropdown_;
    private getVoiceTitle_;
    private stringToHtmlTestId_;
    protected onVoiceSelectClick_(e: Event): void;
    protected onVoicePreviewClick_(e: Event): void;
    protected openLanguageMenu_(): void;
    protected onLanguageMenuClose_(event: CustomEvent): void;
    protected onClose_(): void;
    private shouldAllowPropagation_;
    protected onVoiceMenuKeyDown_(e: KeyboardEvent): void;
    protected previewLabel_(previewPlaying: boolean): string;
    protected hideSpinner_(voiceDropdown: VoiceDropdownItem): boolean;
    protected voiceLabel_(selected: boolean, voiceName: string): string;
    protected shouldDisableButton_(voiceDropdown: VoiceDropdownItem): boolean;
    protected previewIcon_(previewInitiated: boolean): string;
    private getVoiceItemForEvent_;
    private computeErrorMessages_;
    private computeDownloadingMessages_;
    private computeMessages_;
    private getDisplayNameForLocale;
}
declare global {
    interface HTMLElementTagNameMap {
        'voice-selection-menu': VoiceSelectionMenuElement;
    }
}
export {};
