import type { VoiceClientSideStatusCode, VoicePackStatus } from './voice_language_conversions.js';
export declare class VoiceLanguageModel {
    private localInstallState_;
    private cachedServerInstallState_;
    private availableVoices_;
    private availableLangs_;
    private enabledLangs_;
    private possiblyDisabledLangs_;
    private languagesForVoiceDownloads_;
    private waitingForNewEngine_;
    private currentVoice_;
    private currentLanguage_;
    getWaitingForNewEngine(): boolean;
    setWaitingForNewEngine(waitingForNewEngine: boolean): void;
    addLanguageForDownload(lang: string): void;
    removeLanguageForDownload(lang: string): void;
    hasLanguageForDownload(lang: string): boolean;
    getEnabledLangs(): Set<string>;
    enableLang(lang: string): void;
    disableLang(lang: string): void;
    getAvailableLangs(): Set<string>;
    setAvailableLangs(langs: string[]): void;
    getAvailableVoices(): SpeechSynthesisVoice[];
    setAvailableVoices(voices: SpeechSynthesisVoice[]): void;
    getPossiblyDisabledLangs(): Set<string>;
    addPossiblyDisabledLang(lang: string): void;
    removePossiblyDisabledLang(lang: string): void;
    getServerStatus(lang: string): VoicePackStatus | null;
    setServerStatus(lang: string, status: VoicePackStatus): void;
    getLocalStatus(lang: string): VoiceClientSideStatusCode | null;
    setLocalStatus(lang: string, status: VoiceClientSideStatusCode): void;
    getServerLanguages(): string[];
    getCurrentVoice(): SpeechSynthesisVoice | null;
    setCurrentVoice(voice: SpeechSynthesisVoice | null): void;
    getCurrentLanguage(): string;
    setCurrentLanguage(language: string): void;
}
