export declare const MAX_SPEECH_LENGTH: number;
export interface SpeechListener {
    onIsSpeechActiveChange(): void;
    onIsAudioCurrentlyPlayingChange(): void;
    onEngineStateChange(): void;
    onPreviewVoicePlaying(): void;
    onPlayingFromSelection(): void;
}
export declare class SpeechController {
    private model_;
    private speech_;
    private logger_;
    private nodeStore_;
    private voiceLanguageController_;
    private wordBoundaries_;
    private highlighter_;
    private selectionController_;
    private listeners_;
    private readAloudModel_;
    constructor();
    resetForNewContent(): void;
    addListener(listener: SpeechListener): void;
    private setState_;
    isSpeechActive(): boolean;
    private setIsSpeechActive_;
    isSpeechBeingRepositioned(): boolean;
    isAudioCurrentlyPlaying(): boolean;
    private setIsAudioCurrentlyPlaying_;
    isEngineLoaded(): boolean;
    private setEngineState_;
    getPreviewVoicePlaying(): SpeechSynthesisVoice | null;
    private setPreviewVoicePlaying_;
    hasSpeechBeenTriggered(): boolean;
    setHasSpeechBeenTriggered(hasSpeechBeenTriggered: boolean): void;
    isSpeechTreeInitialized(): boolean;
    isPausedFromButton(): boolean;
    isTemporaryPause(): boolean;
    initializeSpeechTree(context?: Node): void;
    onSelectionChange(): void;
    onLockScreen(): void;
    onTabMuteStateChange(muted: boolean): void;
    onVoiceSelected(selectedVoice: SpeechSynthesisVoice): void;
    onSpeechSettingsChange(): void;
    onHighlightGranularityChange(newGranularity: number): void;
    onPlayPauseKeyPress(context: HTMLElement | null): void;
    onPlayPauseToggle(context: HTMLElement | null): void;
    private playSpeech_;
    onNextGranularityClick(): void;
    private moveToNextGranularity_;
    onPreviousGranularityClick(): void;
    private moveToPreviousGranularity_;
    private resumeSpeech_;
    private playSpeechForTheFirstTime_;
    private playFromSelection_;
    private highlightAndPlayInterruptedMessage_;
    private highlightAndPlayMessage_;
    private skipCurrentPosition_;
    private playText_;
    private playTextWithBoundaries_;
    private countWordsHeardIfNeeded;
    private handleSpeechSynthesisError_;
    private stopSpeech_;
    private setOnSpeechSynthesisUtteranceStart_;
    private setOnBoundary_;
    private speakMessage_;
    previewVoice(previewVoice: SpeechSynthesisVoice | null): void;
    onVoiceMenuOpen(): void;
    onVoiceMenuClose(): void;
    private onSpeechInterrupted_;
    private onSpeechFinished_;
    onScroll(): void;
    clearReadAloudState(): void;
    saveReadAloudState(): void;
    setPreviousReadingPositionIfExists(): boolean;
    private movePlaybackToNode_;
    private findSegment_;
    private highlightCurrentGranularity_;
    private isTextTooLong_;
    private getUtteranceText_;
    private getAccessibleUtterance_;
    private isSpeechActiveChanged_;
    private isAudioCurrentlyPlayingChanged_;
    private speakWithDefaults_;
    private logSpeechPlaySession_;
    static getInstance(): SpeechController;
    static setInstance(obj: SpeechController): void;
}
