import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '/strings.m.js';
import 'chrome://resources/cr_elements/cr_toggle/cr_toggle.js';
import type { ProductInfo } from '//resources/cr_components/commerce/shared.mojom-webui.js';
import type { PriceInsightsInfo } from '//resources/cr_components/commerce/shopping_service.mojom-webui.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface PriceTrackingSection {
    $: {
        toggleTitle: HTMLElement;
        toggleAnnotation: HTMLElement;
        toggle: HTMLElement;
    };
}
export declare class PriceTrackingSection extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        productInfo: ObjectConstructor;
        isProductTracked: {
            type: BooleanConstructor;
            value: boolean;
        };
        folderName_: StringConstructor;
        saveLocationEndText_: StringConstructor;
        saveLocationStartText_: StringConstructor;
        showSaveLocationText_: BooleanConstructor;
        toggleAnnotationText_: StringConstructor;
    };
    productInfo: ProductInfo;
    isProductTracked: boolean;
    private folderName_;
    private saveLocationStartText_;
    private saveLocationEndText_;
    private showSaveLocationText_;
    private toggleAnnotationText_;
    priceInsightsInfo: PriceInsightsInfo;
    private listenerIds_;
    private shoppingApi_;
    private priceTrackingProxy_;
    connectedCallback(): void;
    private updatePriceTrackingSection_;
    private updateSaveLocationText;
    disconnectedCallback(): void;
    private onPriceTrackingToggled_;
    private onBookmarkPriceTracked;
    private onBookmarkPriceUntracked;
    private onFolderClicked_;
    private onBookmarkOperationFailed;
    private onProductBookmarkMoved;
}
declare global {
    interface HTMLElementTagNameMap {
        'price-tracking-section': PriceTrackingSection;
    }
}
