import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-hidden-style">#toggleSection{align-items:center;display:flex;max-width:100%}#toggleTitle{color:var(--cr-primary-text-color);font-size:14px;font-weight:500;margin-bottom:8px}#toggleAnnotationButton{color:var(--cr-link-color)}#toggleAnnotation{color:var(--cr-secondary-text-color);display:inline;font-size:12px;line-height:16px;overflow:hidden;white-space:initial}#toggleText{align-items:flex-start;display:flex;flex-direction:column;line-height:20px;margin-right:10px;margin-top:-1px;max-width:100%}#toggle{margin-inline-end:0px;margin-inline-start:auto}</style>

<div id="toggleSection">
  <div id="toggleText">
    <div id="toggleTitle">$i18n{trackPriceTitle}</div>
    <!-- This is a special handling to make sure that the annotation text,
    folder name and period will be in the same line. -->
    <div id="toggleAnnotation">
      [[toggleAnnotationText_]]
      <span hidden="[[!showSaveLocationText_]]">
        [[saveLocationStartText_]]<a href="#"
            id="toggleAnnotationButton"
            on-click="onFolderClicked_"
            >[[folderName_]]</a>[[saveLocationEndText_]]
      </span>
    </div>
  </div>
  <cr-toggle id="toggle" checked="{{isProductTracked}}"
      on-change="onPriceTrackingToggled_" title="$i18n{trackPriceTitle}"
      aria-describedby="toggleAnnotation">
  </cr-toggle>
</div><!--_html_template_end_-->`;
}