// components/commerce/core/mojom/price_tracking.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  BookmarkProductInfoSpec as commerce_shared_mojom_BookmarkProductInfoSpec,
  BookmarkProductInfo as commerce_shared_mojom_BookmarkProductInfo
} from './shared.mojom-webui.js';
import {
  String16Spec as mojoBase_mojom_String16Spec,
  String16 as mojoBase_mojom_String16
} from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';







export type PriceTrackingHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PriceTrackingHandlerPendingReceiver>;

export class PriceTrackingHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PriceTrackingHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PriceTrackingHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PriceTrackingHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.price_tracking.mojom.PriceTrackingHandler',
        scope);
  }
}

export interface PriceTrackingHandlerInterface {
  trackPriceForBookmark(bookmarkId: bigint): void;
  untrackPriceForBookmark(bookmarkId: bigint): void;
  setPriceTrackingStatusForCurrentUrl(track: boolean): void;
  getAllShoppingBookmarkProductInfo(): Promise<{
        productInfos: commerce_shared_mojom_BookmarkProductInfo[], }>;
  getAllPriceTrackedBookmarkProductInfo(): Promise<{
        productInfos: commerce_shared_mojom_BookmarkProductInfo[], }>;
  getShoppingCollectionBookmarkFolderId(): Promise<{
        collectionId: bigint, }>;
  getParentBookmarkFolderNameForCurrentUrl(): Promise<{
        name: mojoBase_mojom_String16, }>;
  showBookmarkEditorForCurrentUrl(): void;
}

export class PriceTrackingHandlerRemote implements PriceTrackingHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PriceTrackingHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PriceTrackingHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PriceTrackingHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PriceTrackingHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  trackPriceForBookmark(
      bookmarkId: bigint): void {
    this.proxy.sendMessage(
        0,
        PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec.$,
        null,
        [
          bookmarkId
        ],
        false);
  }

  untrackPriceForBookmark(
      bookmarkId: bigint): void {
    this.proxy.sendMessage(
        1,
        PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec.$,
        null,
        [
          bookmarkId
        ],
        false);
  }

  setPriceTrackingStatusForCurrentUrl(
      track: boolean): void {
    this.proxy.sendMessage(
        2,
        PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec.$,
        null,
        [
          track
        ],
        false);
  }

  getAllShoppingBookmarkProductInfo(): Promise<{
        productInfos: commerce_shared_mojom_BookmarkProductInfo[], }> {
    return this.proxy.sendMessage(
        3,
        PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec.$,
        PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getAllPriceTrackedBookmarkProductInfo(): Promise<{
        productInfos: commerce_shared_mojom_BookmarkProductInfo[], }> {
    return this.proxy.sendMessage(
        4,
        PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec.$,
        PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getShoppingCollectionBookmarkFolderId(): Promise<{
        collectionId: bigint, }> {
    return this.proxy.sendMessage(
        5,
        PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec.$,
        PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getParentBookmarkFolderNameForCurrentUrl(): Promise<{
        name: mojoBase_mojom_String16, }> {
    return this.proxy.sendMessage(
        6,
        PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec.$,
        PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  showBookmarkEditorForCurrentUrl(): void {
    this.proxy.sendMessage(
        7,
        PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PriceTrackingHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PriceTrackingHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PriceTrackingHandlerRemote, PriceTrackingHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PriceTrackingHandlerRemote, PriceTrackingHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PriceTrackingHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PriceTrackingHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec.$,
        null,
        impl.trackPriceForBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec.$,
        null,
        impl.untrackPriceForBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec.$,
        null,
        impl.setPriceTrackingStatusForCurrentUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec.$,
        PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec.$,
        impl.getAllShoppingBookmarkProductInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec.$,
        PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec.$,
        impl.getAllPriceTrackedBookmarkProductInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec.$,
        PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec.$,
        impl.getShoppingCollectionBookmarkFolderId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec.$,
        PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec.$,
        impl.getParentBookmarkFolderNameForCurrentUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec.$,
        null,
        impl.showBookmarkEditorForCurrentUrl.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PriceTrackingHandler {
  static get $interfaceName(): string {
    return "commerce.price_tracking.mojom.PriceTrackingHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PriceTrackingHandlerRemote {
    let remote = new PriceTrackingHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PriceTrackingHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PriceTrackingHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PriceTrackingHandlerRemote, PriceTrackingHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PriceTrackingHandlerRemote, PriceTrackingHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  trackPriceForBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  untrackPriceForBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPriceTrackingStatusForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getAllShoppingBookmarkProductInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getAllPriceTrackedBookmarkProductInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getShoppingCollectionBookmarkFolderId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getParentBookmarkFolderNameForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showBookmarkEditorForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PriceTrackingHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.trackPriceForBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec.$,
        null,
        this.trackPriceForBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.untrackPriceForBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec.$,
        null,
        this.untrackPriceForBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setPriceTrackingStatusForCurrentUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec.$,
        null,
        this.setPriceTrackingStatusForCurrentUrl.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getAllShoppingBookmarkProductInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec.$,
        PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec.$,
        this.getAllShoppingBookmarkProductInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getAllPriceTrackedBookmarkProductInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec.$,
        PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec.$,
        this.getAllPriceTrackedBookmarkProductInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getShoppingCollectionBookmarkFolderId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec.$,
        PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec.$,
        this.getShoppingCollectionBookmarkFolderId.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getParentBookmarkFolderNameForCurrentUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec.$,
        PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec.$,
        this.getParentBookmarkFolderNameForCurrentUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.showBookmarkEditorForCurrentUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec.$,
        null,
        this.showBookmarkEditorForCurrentUrl.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.price_tracking.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  priceTrackedForBookmark(bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo): void;
  priceUntrackedForBookmark(bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo): void;
  operationFailedForBookmark(bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo, attemptedTrack: boolean): void;
  onProductBookmarkMoved(bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  priceTrackedForBookmark(
      bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo): void {
    this.proxy.sendMessage(
        0,
        Page_PriceTrackedForBookmark_ParamsSpec.$,
        null,
        [
          bookmarkProduct
        ],
        false);
  }

  priceUntrackedForBookmark(
      bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo): void {
    this.proxy.sendMessage(
        1,
        Page_PriceUntrackedForBookmark_ParamsSpec.$,
        null,
        [
          bookmarkProduct
        ],
        false);
  }

  operationFailedForBookmark(
      bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo,
      attemptedTrack: boolean): void {
    this.proxy.sendMessage(
        2,
        Page_OperationFailedForBookmark_ParamsSpec.$,
        null,
        [
          bookmarkProduct,
          attemptedTrack
        ],
        false);
  }

  onProductBookmarkMoved(
      bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo): void {
    this.proxy.sendMessage(
        3,
        Page_OnProductBookmarkMoved_ParamsSpec.$,
        null,
        [
          bookmarkProduct
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_PriceTrackedForBookmark_ParamsSpec.$,
        null,
        impl.priceTrackedForBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_PriceUntrackedForBookmark_ParamsSpec.$,
        null,
        impl.priceUntrackedForBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_OperationFailedForBookmark_ParamsSpec.$,
        null,
        impl.operationFailedForBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_OnProductBookmarkMoved_ParamsSpec.$,
        null,
        impl.onProductBookmarkMoved.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "commerce.price_tracking.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  priceTrackedForBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  priceUntrackedForBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  operationFailedForBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onProductBookmarkMoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.priceTrackedForBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_PriceTrackedForBookmark_ParamsSpec.$,
        null,
        this.priceTrackedForBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.priceUntrackedForBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_PriceUntrackedForBookmark_ParamsSpec.$,
        null,
        this.priceUntrackedForBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.operationFailedForBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_OperationFailedForBookmark_ParamsSpec.$,
        null,
        this.operationFailedForBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onProductBookmarkMoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_OnProductBookmarkMoved_ParamsSpec.$,
        null,
        this.onProductBookmarkMoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PriceTrackingHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PriceTrackingHandlerFactoryPendingReceiver>;

export class PriceTrackingHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PriceTrackingHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PriceTrackingHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PriceTrackingHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.price_tracking.mojom.PriceTrackingHandlerFactory',
        scope);
  }
}

export interface PriceTrackingHandlerFactoryInterface {
  createPriceTrackingHandler(page: PageRemote, handler: PriceTrackingHandlerPendingReceiver): void;
}

export class PriceTrackingHandlerFactoryRemote implements PriceTrackingHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PriceTrackingHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PriceTrackingHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PriceTrackingHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PriceTrackingHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPriceTrackingHandler(
      page: PageRemote,
      handler: PriceTrackingHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PriceTrackingHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PriceTrackingHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PriceTrackingHandlerFactoryRemote, PriceTrackingHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PriceTrackingHandlerFactoryRemote, PriceTrackingHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PriceTrackingHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PriceTrackingHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec.$,
        null,
        impl.createPriceTrackingHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PriceTrackingHandlerFactory {
  static get $interfaceName(): string {
    return "commerce.price_tracking.mojom.PriceTrackingHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PriceTrackingHandlerFactoryRemote {
    let remote = new PriceTrackingHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PriceTrackingHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PriceTrackingHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PriceTrackingHandlerFactoryRemote, PriceTrackingHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PriceTrackingHandlerFactoryRemote, PriceTrackingHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPriceTrackingHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PriceTrackingHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPriceTrackingHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec.$,
        null,
        this.createPriceTrackingHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_PriceTrackedForBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_PriceUntrackedForBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OperationFailedForBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnProductBookmarkMoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PriceTrackingHandler_TrackPriceForBookmark_ParamsMojoType {
  bookmarkId: bigint;
}


export type PriceTrackingHandler_TrackPriceForBookmark_Params = PriceTrackingHandler_TrackPriceForBookmark_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_TrackPriceForBookmark_ParamsMojoType>(
    PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec.$,
    'PriceTrackingHandler_TrackPriceForBookmark_Params',
    [
      mojo.internal.StructField<PriceTrackingHandler_TrackPriceForBookmark_ParamsMojoType, bigint>(
        'bookmarkId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PriceTrackingHandler_UntrackPriceForBookmark_ParamsMojoType {
  bookmarkId: bigint;
}


export type PriceTrackingHandler_UntrackPriceForBookmark_Params = PriceTrackingHandler_UntrackPriceForBookmark_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_UntrackPriceForBookmark_ParamsMojoType>(
    PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec.$,
    'PriceTrackingHandler_UntrackPriceForBookmark_Params',
    [
      mojo.internal.StructField<PriceTrackingHandler_UntrackPriceForBookmark_ParamsMojoType, bigint>(
        'bookmarkId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsMojoType {
  track: boolean;
}


export type PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_Params = PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsMojoType>(
    PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec.$,
    'PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_Params',
    [
      mojo.internal.StructField<PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsMojoType, boolean>(
        'track', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsMojoType {
}


export type PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_Params = PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsMojoType>(
    PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec.$,
    'PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_Params',
    [
    ],
    [[0, 8],]);





export interface PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsMojoType {
  productInfos: commerce_shared_mojom_BookmarkProductInfo[];
}


export type PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParams = PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsMojoType>(
    PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec.$,
    'PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParams',
    [
      mojo.internal.StructField<PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsMojoType, commerce_shared_mojom_BookmarkProductInfo[]>(
        'productInfos', 0,
        0,
        mojo.internal.Array(commerce_shared_mojom_BookmarkProductInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsMojoType {
}


export type PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_Params = PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsMojoType>(
    PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec.$,
    'PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_Params',
    [
    ],
    [[0, 8],]);





export interface PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsMojoType {
  productInfos: commerce_shared_mojom_BookmarkProductInfo[];
}


export type PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParams = PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsMojoType>(
    PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec.$,
    'PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParams',
    [
      mojo.internal.StructField<PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsMojoType, commerce_shared_mojom_BookmarkProductInfo[]>(
        'productInfos', 0,
        0,
        mojo.internal.Array(commerce_shared_mojom_BookmarkProductInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsMojoType {
}


export type PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_Params = PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsMojoType>(
    PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec.$,
    'PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_Params',
    [
    ],
    [[0, 8],]);





export interface PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsMojoType {
  collectionId: bigint;
}


export type PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParams = PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsMojoType>(
    PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec.$,
    'PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParams',
    [
      mojo.internal.StructField<PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsMojoType, bigint>(
        'collectionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsMojoType {
}


export type PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_Params = PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsMojoType>(
    PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec.$,
    'PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_Params',
    [
    ],
    [[0, 8],]);





export interface PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsMojoType {
  name: mojoBase_mojom_String16;
}


export type PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParams = PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsMojoType>(
    PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec.$,
    'PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParams',
    [
      mojo.internal.StructField<PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsMojoType, mojoBase_mojom_String16>(
        'name', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsMojoType {
}


export type PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_Params = PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsMojoType>(
    PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec.$,
    'PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_Params',
    [
    ],
    [[0, 8],]);





export interface Page_PriceTrackedForBookmark_ParamsMojoType {
  bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo;
}


export type Page_PriceTrackedForBookmark_Params = Page_PriceTrackedForBookmark_ParamsMojoType;
mojo.internal.Struct<Page_PriceTrackedForBookmark_ParamsMojoType>(
    Page_PriceTrackedForBookmark_ParamsSpec.$,
    'Page_PriceTrackedForBookmark_Params',
    [
      mojo.internal.StructField<Page_PriceTrackedForBookmark_ParamsMojoType, commerce_shared_mojom_BookmarkProductInfo>(
        'bookmarkProduct', 0,
        0,
        commerce_shared_mojom_BookmarkProductInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_PriceUntrackedForBookmark_ParamsMojoType {
  bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo;
}


export type Page_PriceUntrackedForBookmark_Params = Page_PriceUntrackedForBookmark_ParamsMojoType;
mojo.internal.Struct<Page_PriceUntrackedForBookmark_ParamsMojoType>(
    Page_PriceUntrackedForBookmark_ParamsSpec.$,
    'Page_PriceUntrackedForBookmark_Params',
    [
      mojo.internal.StructField<Page_PriceUntrackedForBookmark_ParamsMojoType, commerce_shared_mojom_BookmarkProductInfo>(
        'bookmarkProduct', 0,
        0,
        commerce_shared_mojom_BookmarkProductInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OperationFailedForBookmark_ParamsMojoType {
  bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo;
  attemptedTrack: boolean;
}


export type Page_OperationFailedForBookmark_Params = Page_OperationFailedForBookmark_ParamsMojoType;
mojo.internal.Struct<Page_OperationFailedForBookmark_ParamsMojoType>(
    Page_OperationFailedForBookmark_ParamsSpec.$,
    'Page_OperationFailedForBookmark_Params',
    [
      mojo.internal.StructField<Page_OperationFailedForBookmark_ParamsMojoType, commerce_shared_mojom_BookmarkProductInfo>(
        'bookmarkProduct', 0,
        0,
        commerce_shared_mojom_BookmarkProductInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OperationFailedForBookmark_ParamsMojoType, boolean>(
        'attemptedTrack', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_OnProductBookmarkMoved_ParamsMojoType {
  bookmarkProduct: commerce_shared_mojom_BookmarkProductInfo;
}


export type Page_OnProductBookmarkMoved_Params = Page_OnProductBookmarkMoved_ParamsMojoType;
mojo.internal.Struct<Page_OnProductBookmarkMoved_ParamsMojoType>(
    Page_OnProductBookmarkMoved_ParamsSpec.$,
    'Page_OnProductBookmarkMoved_Params',
    [
      mojo.internal.StructField<Page_OnProductBookmarkMoved_ParamsMojoType, commerce_shared_mojom_BookmarkProductInfo>(
        'bookmarkProduct', 0,
        0,
        commerce_shared_mojom_BookmarkProductInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsMojoType {
  page: PageRemote;
  handler: PriceTrackingHandlerPendingReceiver;
}


export type PriceTrackingHandlerFactory_CreatePriceTrackingHandler_Params = PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsMojoType;
mojo.internal.Struct<PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsMojoType>(
    PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec.$,
    'PriceTrackingHandlerFactory_CreatePriceTrackingHandler_Params',
    [
      mojo.internal.StructField<PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsMojoType, PriceTrackingHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PriceTrackingHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



