import 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import type { CrUrlListItemElement } from 'chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import { CrUrlListItemSize } from 'chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import type { BookmarksTreeNode } from './bookmarks.mojom-webui.js';
export declare const NESTED_BOOKMARKS_BASE_MARGIN = 28;
export declare const NESTED_BOOKMARKS_MARGIN_PER_DEPTH = 12;
export declare const BOOKMARK_ROW_LOAD_EVENT = "bookmark-row-connected-event";
export declare class PowerBookmarkRowElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        bookmark: {
            type: ObjectConstructor;
        };
        compact: {
            type: BooleanConstructor;
        };
        bookmarksTreeViewEnabled: {
            type: BooleanConstructor;
        };
        contextMenuBookmark: {
            type: ObjectConstructor;
        };
        depth: {
            type: NumberConstructor;
            reflect: boolean;
        };
        hasCheckbox: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        selectedBookmarks: {
            type: ArrayConstructor;
        };
        renamingId: {
            type: StringConstructor;
        };
        imageUrls: {
            type: ObjectConstructor;
        };
        isPriceTracked: {
            type: BooleanConstructor;
        };
        searchQuery: {
            type: StringConstructor;
        };
        shoppingCollectionFolderId: {
            type: StringConstructor;
        };
        rowAriaDescription: {
            type: StringConstructor;
        };
        trailingIconTooltip: {
            type: StringConstructor;
        };
        listItemSize: {
            type: StringConstructor;
        };
        toggleExpand: {
            type: BooleanConstructor;
        };
        isSelected: {
            type: BooleanConstructor;
        };
        updatedElementIds: {
            type: ArrayConstructor;
        };
        canDrag: {
            type: BooleanConstructor;
        };
        activeFolderPath: {
            type: ArrayConstructor;
        };
        hasFolders: {
            type: BooleanConstructor;
            reflect: boolean;
        };
    };
    accessor bookmark: BookmarksTreeNode;
    accessor compact: boolean;
    accessor contextMenuBookmark: BookmarksTreeNode | undefined;
    accessor bookmarksTreeViewEnabled: boolean;
    accessor depth: number;
    accessor hasCheckbox: boolean;
    accessor selectedBookmarks: BookmarksTreeNode[];
    accessor renamingId: string;
    accessor searchQuery: string | undefined;
    accessor shoppingCollectionFolderId: string;
    accessor rowAriaDescription: string;
    accessor trailingIconTooltip: string;
    accessor toggleExpand: boolean;
    accessor isSelected: boolean;
    accessor imageUrls: {
        [key: string]: string;
    };
    accessor updatedElementIds: string[];
    accessor isPriceTracked: boolean;
    accessor canDrag: boolean;
    accessor activeFolderPath: BookmarksTreeNode[];
    accessor hasFolders: boolean;
    accessor listItemSize: CrUrlListItemSize;
    private bookmarksService_;
    private priceTrackingProxy_;
    private shoppingListenerIds_;
    private keyArrowNavigationService_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    protected getUrl_(): string | undefined;
    private handleBookmarkSubscriptionChange_;
    willUpdate(changedProperties: PropertyValues<this>): void;
    updated(changedProperties: PropertyValues<this>): void;
    shouldUpdate(changedProperties: PropertyValues<this>): boolean;
    getUpdateComplete(): Promise<boolean>;
    focus(): void;
    private setExpanded_;
    private onKeydown_;
    getBookmarkDescriptionForTests(bookmark: BookmarksTreeNode): string | undefined;
    private onFocus_;
    get currentUrlListItem_(): CrLitElement & CrUrlListItemElement;
    protected handleListItemSizeChanged_(): Promise<void>;
    protected isRenamingItem_(): boolean;
    protected isCheckboxChecked_(): boolean;
    protected isBookmarksBar_(): boolean;
    protected showTrailingIcon_(): boolean;
    protected onExpandedChanged_(event: CustomEvent<{
        value: boolean;
    }>): void;
    private onInputDisplayChange_;
    /**
     * Dispatches a custom click event when the user clicks anywhere on the row.
     */
    protected onRowClicked_(event: MouseEvent): void;
    /**
     * Dispatches a custom click event when the user right-clicks anywhere on the
     * row.
     */
    protected onContextMenu_(event: MouseEvent): void;
    /**
     * Dispatches a custom click event when the user clicks anywhere on the
     * trailing icon button.
     */
    protected onTrailingIconClicked_(event: MouseEvent): void;
    /**
     * Dispatches a custom click event when the user clicks on the checkbox.
     */
    protected onCheckboxChange_(event: Event): void;
    /**
     * Triggers an input change event on enter. Extends default input behavior
     * which only triggers a change event if the value of the input has changed.
     */
    protected onInputKeyDown_(event: KeyboardEvent): void;
    private createInputChangeEvent_;
    /**
     * Triggers a custom input change event when the user hits enter or the input
     * loses focus.
     */
    protected onInputChange_(event: Event): void;
    protected onInputBlur_(event: Event): void;
    private isPriceTracked_;
    /**
     * Whether the given price-tracked bookmark should display as if discounted.
     */
    protected showDiscountedPrice_(): boolean;
    protected getCurrentPrice_(bookmark: BookmarksTreeNode): string;
    protected getPreviousPrice_(bookmark: BookmarksTreeNode): string;
    protected getBookmarkForceHover_(): boolean;
    protected shouldExpand_(): boolean | null;
    protected canEdit_(): boolean;
    protected isShoppingCollection_(): boolean;
    protected isFolder_(): boolean;
    protected isFolderWithChildren_(): boolean;
    protected getBookmarkDescription_(bookmark: BookmarksTreeNode): string | undefined;
    protected getBookmarkImageUrls_(): string[];
    protected getBookmarkMenuA11yLabel_(): string;
    protected getBookmarkA11yLabel_(): string;
    protected getBookmarkA11yDescription_(): string;
    protected getBookmarkDescriptionMeta_(): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'power-bookmark-row': PowerBookmarkRowElement;
    }
}
