// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";export class KeyArrowNavigationService{elements_=[];rootElement_;focusIndex_=0;childrenQuerySelector_="";constructor(rootElement,querySelector){this.rootElement_=rootElement;this.childrenQuerySelector_=querySelector}boundKeyArrowListener_=this.handleKeyArrowEvent_.bind(this);startListening(){this.rootElement_.addEventListener("keydown",this.boundKeyArrowListener_)}stopListening(){this.rootElement_.removeEventListener("keydown",this.boundKeyArrowListener_)}addElementsWithin(parentElement){const childElements=this.traverseElements_(parentElement);const newElements=[...this.elements_];const targetIndex=this.findElementIndex_(parentElement);newElements.splice(targetIndex+1,0,...childElements);this.elements_=newElements}removeElementsWithin(parentElement){const updatedElements=[...this.elements_];const numElementsToRemove=this.traverseElements_(parentElement).length;const targetIndex=this.findElementIndex_(parentElement);updatedElements.splice(targetIndex+1,numElementsToRemove);this.elements_=updatedElements}setCurrentFocusIndex(element){const newCurrentIndex=this.findElementIndex_(element);if(newCurrentIndex<0){return false}this.focusIndex_=newCurrentIndex;return true}rebuildNavigationElements(rootElement){this.elements_=this.traverseElements_(rootElement||this.rootElement_)}getElementAtFocusIndexForTesting(){return this.elements_[this.focusIndex_]}getElementsForTesting(){return[...this.elements_]}getElementCount(){return this.elements_.length}moveFocus(direction){if(this.focusIndex_+direction>this.elements_.length-1){this.focusIndex_=0;this.focusCurrentIndex_();return}if(this.focusIndex_+direction<0){this.focusIndex_=this.elements_.length-1;this.focusCurrentIndex_();return}this.focusIndex_+=direction;this.focusCurrentIndex_()}handleKeyArrowEvent_(event){const{key:key}=event;if(!(key==="ArrowUp"||key==="ArrowDown")){return}event.preventDefault();event.stopPropagation();if(key==="ArrowUp"){this.moveFocus(-1)}if(key==="ArrowDown"){this.moveFocus(1)}}focusCurrentIndex_(){this.elements_[this.focusIndex_].focus()}findElementIndex_(element){return this.elements_.findIndex((elem=>elem===element))}traverseElements_(node){const children=Array.from(node.shadowRoot.querySelectorAll(this.childrenQuerySelector_));let treeElements=[];for(const childNode of children){const hasChildren=childNode.shadowRoot&&Array.from(childNode.shadowRoot.querySelectorAll(this.childrenQuerySelector_)).length>0;treeElements=hasChildren?[...treeElements,childNode,...this.traverseElements_(childNode)]:[...treeElements,childNode]}return treeElements}static getInstance(){assert(instance);return instance}static setInstance(obj){instance=obj}}let instance=null;