// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{dedupingMixin}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{CrPolicyPrefMixin}from"./cr_policy_pref_mixin.js";import{PrefControlMixin}from"./pref_control_mixin.js";export const DEFAULT_UNCHECKED_VALUE=0;export const DEFAULT_CHECKED_VALUE=1;export const SettingsBooleanControlMixin=dedupingMixin((superClass=>{const superClassBase=CrPolicyPrefMixin(PrefControlMixin(superClass));class SettingsBooleanControlMixin extends superClassBase{static get properties(){return{inverted:{type:Boolean,value:false},checked:{type:Boolean,value:false,notify:true,reflectToAttribute:true},disabled:{type:Boolean,value:false,notify:true,reflectToAttribute:true},noSetPref:{type:Boolean,value:false},label:{type:String,value:""},subLabel:{type:String,value:""},numericUncheckedValues:{type:Array,value:()=>[DEFAULT_UNCHECKED_VALUE]},numericCheckedValue:{type:Number,value:DEFAULT_CHECKED_VALUE}}}static get observers(){return["prefValueChanged_(pref.value)"]}notifyChangedByUserInteraction(){this.dispatchEvent(new CustomEvent("settings-boolean-control-change",{bubbles:true,composed:true}));if(!this.pref||this.noSetPref){return}this.sendPrefChange()}resetToPrefValue(){if(this.pref===undefined){this.checked=false;return}this.checked=this.getNewValue_(this.pref.value)}sendPrefChange(){if(this.pref.type===chrome.settingsPrivate.PrefType.NUMBER){assert(!this.inverted);assert(this.numericUncheckedValues.length>0);this.set("pref.value",this.checked?this.numericCheckedValue:this.numericUncheckedValues[0]);return}this.set("pref.value",this.inverted?!this.checked:this.checked)}prefValueChanged_(prefValue){this.checked=this.getNewValue_(prefValue)}getNewValue_(value){if(this.pref.type===chrome.settingsPrivate.PrefType.NUMBER){assert(!this.inverted);return!this.numericUncheckedValues.includes(value)}return this.inverted?!value:!!value}controlDisabled(){return this.disabled||this.isPrefEnforced()||!!(this.pref&&this.pref.userControlDisabled)}}return SettingsBooleanControlMixin}));