/**
 * @fileoverview 'settings-search-engines-list' is a component for showing a
 * list of search engines.
 */
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import './search_engine_entry.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SearchEngine } from './search_engines_browser_proxy.js';
export declare class SettingsSearchEnginesListElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        engines: ArrayConstructor;
        showShortcut: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        showQueryUrl: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        collapseList: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        /**
         * The number of engines visible when the list is collapsed.
         */
        visibleEnginesSize: {
            type: NumberConstructor;
            value: number;
        };
        /**
         * An array of the first 'visibleEnginesSize' engines in the `engines`
         * array.  These engines are visible even when 'collapsedEngines' is
         * collapsed.
         */
        visibleEngines: {
            type: ArrayConstructor;
            computed: string;
        };
        /**
         * An array of all remaining engines not in the `visibleEngines` array.
         * These engines' visibility can be toggled by expanding or collapsing the
         * engines list.
         */
        collapsedEngines: {
            type: ArrayConstructor;
            computed: string;
        };
        lastFocused_: ObjectConstructor;
        listBlurred_: BooleanConstructor;
        expandListText: {
            type: StringConstructor;
            reflectToAttribute: boolean;
        };
        fixedHeight: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
    };
    engines: SearchEngine[];
    visibleEngines: SearchEngine[];
    collapsedEngines: SearchEngine[];
    visibleEnginesSize: number;
    fixedHeight: boolean;
    showShortcut: boolean;
    showQueryUrl: boolean;
    collapseList: boolean;
    expandListText: string;
    private lastFocused_;
    private listBlurred_;
    private computeVisibleEngines_;
    private computeCollapsedEngines_;
}
