import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared action-link cr-spinner-style">.spinner{margin:0 8px}#dialog-body{padding-bottom:2px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}"
        ignore-popstate ignore-enter-key>
      <div slot="title">
        [[getPageTitle_(isTriggered_, triggeredResetToolName_)]]
      </div>
      <div id="dialog-body" slot="body">
        <span inner-h-t-m-l="[[getExplanationText_(
              isTriggered_, triggeredResetToolName_)]]">
        </span>
        <a href="$i18nRaw{resetPageLearnMoreUrl}"
            aria-label="$i18n{resetLearnMoreAccessibilityText}"
            target="_blank">$i18n{learnMore}</a>
      </div>
      <div slot="button-container">
        <div class="spinner" hidden$="[[!clearingInProgress_]]"></div>
        <cr-button class="cancel-button" on-click="onCancelClick_"
            id="cancel" disabled="[[clearingInProgress_]]">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onResetClick_"
            id="reset" disabled="[[clearingInProgress_]]">
          $i18n{resetDialogCommit}
        </cr-button>
      </div>
      <div slot="footer">
        <cr-checkbox id="sendSettings" checked>
          $i18nRaw{resetPageFeedback}</cr-checkbox>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}
