import '/shared/settings/prefs/prefs.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../controls/settings_toggle_button.js';
import '../settings_page/settings_subpage.js';
import './privacy_sandbox_interest_item.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
export interface SettingsPrivacySandboxFledgeSubpageElement {
    $: {
        fledgeToggle: SettingsToggleButtonElement;
    };
}
declare const SettingsPrivacySandboxFledgeSubpageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsPrivacySandboxFledgeSubpageElement extends SettingsPrivacySandboxFledgeSubpageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        sitesList_: {
            type: ArrayConstructor;
            observer: string;
            value(): never[];
        };
        /**
         * Helper list used to display the main sites in the current sites
         * section, above the "See all sites" expand button.
         */
        mainSitesList_: {
            type: ArrayConstructor;
            value(): never[];
        };
        /**
         * Helper list used to display the remaining sites in the current sites
         * section that are inside the "See all sites" expandable section.
         */
        remainingSitesList_: {
            type: ArrayConstructor;
            value(): never[];
        };
        blockedSitesList_: {
            type: ArrayConstructor;
            value(): never[];
        };
        /**
         * Used to determine that the Sites list was already fetched and to
         * display the current sites description only after the list is loaded,
         * to avoid displaying first the description for an empty list since the
         * array is empty at first when the page is loaded and switching to the
         * default description once the list is fetched.
         */
        isSitesListLoaded_: {
            type: BooleanConstructor;
            value: boolean;
        };
        isLearnMoreDialogOpen_: {
            type: BooleanConstructor;
            value: boolean;
        };
        seeAllSitesExpanded_: {
            type: BooleanConstructor;
            value: boolean;
            observer: string;
        };
        blockedSitesExpanded_: {
            type: BooleanConstructor;
            value: boolean;
            observer: string;
        };
    };
    static get maxFledgeSites(): number;
    private sitesList_;
    private mainSitesList_;
    private remainingSitesList_;
    private blockedSitesList_;
    private isSitesListLoaded_;
    private isLearnMoreDialogOpen_;
    private seeAllSitesExpanded_;
    private blockedSitesExpanded_;
    private privacySandboxBrowserProxy_;
    private metricsBrowserProxy_;
    ready(): void;
    private isFledgePrefManaged_;
    private onFledgeStateChanged_;
    private onSitesListChanged_;
    private isFledgeEnabledAndLoaded_;
    private isSitesListEmpty_;
    private isRemainingSitesListEmpty_;
    private computeBlockedSitesDescription_;
    private getBlockedSitesDescriptionClass_;
    private onToggleChange_;
    private onLearnMoreClick_;
    private onCloseDialog_;
    private onInterestChanged_;
    private onSeeAllSitesExpanded_;
    private onBlockedSitesExpanded_;
    private onPrivacyPolicyLinkClicked_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-privacy-sandbox-fledge-subpage': SettingsPrivacySandboxFledgeSubpageElement;
    }
}
export {};
