/**
 * @fileoverview 'settings-security-keys-pin-field' is a component for entering
 * a security key PIN.
 */
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '../settings_shared.css.js';
import '../i18n_setup.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
/**
 * A function that submits a PIN to a security key. It returns a Promise which
 * resolves with null if the PIN was correct, or with the number of retries
 * remaining otherwise.
 */
type PinFieldSubmitFunc = (pin: string) => Promise<number | null>;
export interface SettingsSecurityKeysPinFieldElement {
    $: {
        pin: CrInputElement;
    };
}
declare const SettingsSecurityKeysPinFieldElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsSecurityKeysPinFieldElement extends SettingsSecurityKeysPinFieldElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        minPinLength: {
            value: number;
            type: NumberConstructor;
        };
        error_: {
            type: StringConstructor;
            observer: string;
        };
        value_: StringConstructor;
        inputVisible_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    minPinLength: number;
    private error_;
    private value_;
    private inputVisible_;
    /** Focuses the PIN input field. */
    focus(): void;
    /**
     * Validates the PIN and sets the validation error if it is not valid.
     * @return True iff the PIN is valid.
     */
    private validate_;
    /**
     * Attempts submission of the PIN by invoking |submitFunc|. Updates the UI
     * to show an error if the PIN was incorrect.
     * @return A Promise that resolves if the PIN was correct, else rejects.
     */
    trySubmit(submitFunc: PinFieldSubmitFunc): Promise<void>;
    /**
     * Sets the validation error to indicate the PIN was incorrect.
     * @param retries The number of retries remaining.
     */
    private showIncorrectPinError_;
    private onPinInput_;
    /**
     * Polymer helper function to detect when an error string is empty.
     * @return True iff |s| is non-empty.
     */
    private isNonEmpty_;
    /**
     * @return The PIN-input element type.
     */
    private inputType_;
    /**
     * @return The class (and thus icon) to be displayed.
     */
    private showButtonClass_;
    /**
     * @return The tooltip for the icon.
     */
    private showButtonTitle_;
    /**
     * onClick handler for the show/hide icon.
     */
    private showButtonClick_;
    /**
     * @param pin A candidate PIN.
     * @return An error string or else '' to indicate validity.
     */
    private isValidPin_;
    private errorChanged_;
}
export {};
