import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '/shared/settings/prefs/prefs.js';
import '../../controls/controlled_radio_button.js';
import '../../controls/settings_radio_group.js';
import '../../settings_page/settings_subpage.js';
import './security_page_feature_row.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ControlledRadioButtonElement } from '../../controls/controlled_radio_button.js';
import type { SettingsRadioGroupElement } from '../../controls/settings_radio_group.js';
import type { SecurityPageFeatureRowElement } from './security_page_feature_row.js';
/** Enumeration of all security settings bundle modes.*/
export declare enum SecuritySettingsBundleSetting {
    STANDARD = 0,
    ENHANCED = 1
}
/**
 * Enumeration of all Safe Browsing modes. Must be kept in sync with the enum
 * of the same name located in:
 * chrome/browser/safe_browsing/generated_safe_browsing_pref.h
 */
export declare enum SafeBrowsingSetting {
    ENHANCED = 0,
    STANDARD = 1,
    DISABLED = 2
}
export interface SettingsSecurityPageV2Element {
    $: {
        bundlesRadioGroup: SettingsRadioGroupElement;
        securitySettingsBundleEnhanced: ControlledRadioButtonElement;
        securitySettingsBundleStandard: ControlledRadioButtonElement;
        safeBrowsingRadioGroup: SettingsRadioGroupElement;
        safeBrowsingRow: SecurityPageFeatureRowElement;
    };
}
declare const SettingsSecurityPageV2ElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("../../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsSecurityPageV2Element extends SettingsSecurityPageV2ElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        securitySettingsBundleSettingEnum_: {
            type: ObjectConstructor;
            value: typeof SecuritySettingsBundleSetting;
        };
        safeBrowsingSettingEnum_: {
            type: ObjectConstructor;
            value: typeof SafeBrowsingSetting;
        };
        safeBrowsingOff_: {
            type: ArrayConstructor;
            value: () => SafeBrowsingSetting[];
        };
    };
    private safeBrowsingOff_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-security-page-v2': SettingsSecurityPageV2Element;
    }
}
export {};
