/**
 * @fileoverview 'settings-security-keys-set-pin-dialog' is a dialog for
 * setting and changing security key PINs.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_icons.css.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import '../../settings_shared.css.js';
import '../../i18n_setup.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare enum SetPinDialogPage {
    INITIAL = "initial",
    NO_PIN_SUPPORT = "noPINSupport",
    REINSERT = "reinsert",
    LOCKED = "locked",
    ERROR = "error",
    PIN_PROMPT = "pinPrompt",
    SUCCESS = "success"
}
export interface SettingsSecurityKeysSetPinDialogElement {
    $: {
        closeButton: CrButtonElement;
        confirmPIN: CrInputElement;
        currentPIN: CrInputElement;
        currentPINEntry: HTMLElement;
        dialog: CrDialogElement;
        error: HTMLElement;
        newPIN: CrInputElement;
        pinSubmit: CrButtonElement;
    };
}
declare const SettingsSecurityKeysSetPinDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsSecurityKeysSetPinDialogElement extends SettingsSecurityKeysSetPinDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Whether the value of the current PIN textbox is a valid PIN or not.
         */
        currentPINValid_: BooleanConstructor;
        newPINValid_: BooleanConstructor;
        confirmPINValid_: BooleanConstructor;
        /**
         * Whether the dialog is in a state where the Set PIN button should be
         * enabled. Read by Polymer.
         */
        setPINButtonValid_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * The value of the new PIN textbox. Read/write by Polymer.
         */
        newPIN_: {
            type: StringConstructor;
            value: string;
        };
        confirmPIN_: {
            type: StringConstructor;
            value: string;
        };
        currentPIN_: {
            type: StringConstructor;
            value: string;
        };
        /**
         * The minimum length for the currently set PIN.
         */
        currentMinPinLength_: NumberConstructor;
        /**
         * The minimum length to set a new PIN.
         */
        newMinPinLength_: {
            type: NumberConstructor;
            observer: string;
        };
        /**
         * The number of PIN attempts remaining.
         */
        retries_: NumberConstructor;
        /**
         * A CTAP error code when we don't recognise the specific error. Read by
         * Polymer.
         */
        errorCode_: NumberConstructor;
        /**
         * Whether an entry for the current PIN should be displayed. (If no PIN
         * has been set then it won't be shown.)
         */
        showCurrentEntry_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * Error string to display under the current PIN entry, or empty.
         */
        currentPINError_: {
            type: StringConstructor;
            value: string;
        };
        /**
         * Error string to display under the new PIN entry, or empty.
         */
        newPINError_: {
            type: StringConstructor;
            value: string;
        };
        /**
         * Error string to display under the confirmation PIN entry, or empty.
         */
        confirmPINError_: {
            type: StringConstructor;
            value: string;
        };
        /**
         * Whether the dialog process has completed, successfully or otherwise.
         */
        complete_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * The id of an element on the page that is currently shown.
         */
        shown_: {
            type: StringConstructor;
            value: SetPinDialogPage;
        };
        /**
         * Whether the contents of the PIN entries are visible, or are displayed
         * like passwords.
         */
        pinsVisible_: {
            type: BooleanConstructor;
            value: boolean;
        };
        title_: StringConstructor;
        newPINDialogDescription_: StringConstructor;
    };
    private currentPINValid_;
    private newPINValid_;
    private confirmPINValid_;
    private setPINButtonValid_;
    private newPIN_;
    private confirmPIN_;
    private currentPIN_;
    private currentMinPinLength_?;
    private newMinPinLength_?;
    private retries_?;
    private errorCode_?;
    private showCurrentEntry_;
    private currentPINError_;
    private newPINError_;
    private confirmPINError_;
    private complete_;
    private shown_;
    private pinsVisible_;
    private title_;
    private newPINDialogDescription_;
    private browserProxy_;
    connectedCallback(): void;
    private fire_;
    private closeDialog_;
    private finish_;
    private onIronSelect_;
    private onCurrentPinInput_;
    private onNewPinInput_;
    private onConfirmPinInput_;
    /**
      @param pin A candidate PIN.
      @return An error string or else '' to indicate validity.
    */
    private isValidPin_;
    /**
     * @param retries The number of PIN attempts remaining.
     * @return The message to show under the text box.
     */
    private mismatchError_;
    /**
     * Called to set focus from inside a callback.
     */
    private focusOn_;
    /**
     * Called by Polymer when the Set PIN button is activated.
     */
    private pinSubmitNew_;
    /**
     * onClick handler for the show/hide icon.
     */
    private showPinsClick_;
    /**
     * Polymer helper function to detect when an error string is empty.
     */
    private isNonEmpty_;
    /**
     * Called by Polymer when |errorCode_| changes to set the error string.
     */
    private pinFailed_;
    /**
     * @return The class of the Ok / Cancel button.
     */
    private maybeActionButton_;
    /**
     * @return The label of the Ok / Cancel button.
     */
    private closeText_;
    private newMinPinLengthChanged_;
    /**
     * @return The class (and thus icon) to be displayed.
     */
    private showPinsClass_;
    /**
     * @return The tooltip for the icon.
     */
    private showPinsTitle_;
    /**
     * @return The PIN-input element type.
     */
    private inputType_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-security-keys-set-pin-dialog': SettingsSecurityKeysSetPinDialogElement;
    }
}
export {};
