/**
 * @fileoverview 'settings-import-data-dialog' is a component for importing
 * bookmarks and other data from other sources.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/md_select.css.js';
import '../controls/settings_checkbox.js';
import '../controls/settings_toggle_button.js';
import '../settings_vars.css.js';
import '../i18n_setup.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { ImportDataStatus } from './import_data_browser_proxy.js';
export interface SettingsImportDataDialogElement {
    $: {
        browserSelect: HTMLSelectElement;
        cancel: CrButtonElement;
        dialog: CrDialogElement;
        done: CrButtonElement;
        import: CrButtonElement;
        successIcon: HTMLElement;
    };
}
declare const SettingsImportDataDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsImportDataDialogElement extends SettingsImportDataDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        browserProfiles_: ArrayConstructor;
        selected_: {
            type: ObjectConstructor;
            observer: string;
        };
        /**
         * Whether none of the import data categories is selected.
         */
        noImportDataTypeSelected_: {
            type: BooleanConstructor;
            value: boolean;
        };
        importStatus_: {
            type: StringConstructor;
            value: ImportDataStatus;
        };
        /**
         * Mirroring the enum so that it can be used from HTML bindings.
         */
        importStatusEnum_: {
            type: ObjectConstructor;
            value: typeof ImportDataStatus;
        };
    };
    private browserProfiles_;
    private selected_;
    private noImportDataTypeSelected_;
    private importStatus_;
    private browserProxy_;
    ready(): void;
    connectedCallback(): void;
    private getProfileDisplayName_;
    private updateImportDataTypesSelected_;
    /**
     * @return Whether |status| is the current status.
     */
    private hasImportStatus_;
    private isImportFromFileSelected_;
    private getActionButtonText_;
    private onBrowserProfileSelectionChange_;
    private onActionButtonClick_;
    private closeDialog_;
    /**
     * @return Whether the import button should be disabled.
     */
    private shouldDisableImport_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-import-data-dialog': SettingsImportDataDialogElement;
    }
}
export {};
