// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-spell-check-page' is the settings page
 * for spell check settings.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
// 
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_toggle/cr_toggle.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/js/action_link.js';
import 'chrome://resources/cr_elements/action_link.css.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import '../controls/controlled_radio_button.js';
import '../controls/settings_radio_group.js';
import '../controls/settings_toggle_button.js';
import '../icons.html.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import { PrefsMixin } from '/shared/settings/prefs/prefs_mixin.js';
import { I18nMixin } from 'chrome://resources/cr_elements/i18n_mixin.js';
import { assert } from 'chrome://resources/js/assert.js';
import { focusWithoutInk } from 'chrome://resources/js/focus_without_ink.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { BaseMixin } from '../base_mixin.js';
import { SettingsViewMixin } from '../settings_page/settings_view_mixin.js';
import { getLanguageHelperInstance } from './languages.js';
import { LanguageSettingsActionType, LanguageSettingsMetricsProxyImpl } from './languages_settings_metrics_proxy.js';
import { getTemplate } from './spell_check_page.html.js';
const SettingsSpellCheckPageElementBase = SettingsViewMixin(I18nMixin(PrefsMixin(BaseMixin(PolymerElement))));
export class SettingsSpellCheckPageElement extends SettingsSpellCheckPageElementBase {
    static get is() {
        return 'settings-spell-check-page';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            /**
             * Read-only reference to the languages model provided by the
             * 'settings-languages' instance.
             */
            languages: Object,
            // 
            hideSpellCheckLanguages_: {
                type: Boolean,
                value: false,
            },
        };
    }
    languageHelper_;
    languageSettingsMetricsProxy_ = LanguageSettingsMetricsProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.languageHelper_ = getLanguageHelperInstance();
    }
    onSpellCheckToggleChange_(e) {
        this.languageSettingsMetricsProxy_.recordSettingsMetric(e.target.checked ?
            LanguageSettingsActionType.ENABLE_SPELL_CHECK_GLOBALLY :
            LanguageSettingsActionType.DISABLE_SPELL_CHECK_GLOBALLY);
    }
    onSelectedSpellingServiceChange_() {
        this.languageSettingsMetricsProxy_.recordSettingsMetric(this.prefs.spellcheck.use_spelling_service.value ?
            LanguageSettingsActionType.SELECT_ENHANCED_SPELL_CHECK :
            LanguageSettingsActionType.SELECT_BASIC_SPELL_CHECK);
    }
    // 
    //  expr="not is_macosx"
    getSpellCheckSubLabel_() {
        // 
        return undefined;
    }
    /**
     * Toggles the expand button within the element being listened to.
     */
    toggleExpandButton_(e) {
        // The expand button handles toggling itself.
        if (e.target.tagName === 'CR-EXPAND-BUTTON') {
            return;
        }
        if (!e.currentTarget.hasAttribute('actionable')) {
            return;
        }
        const expandButton = e.currentTarget.querySelector('cr-expand-button');
        assert(expandButton);
        expandButton.expanded = !expandButton.expanded;
        focusWithoutInk(expandButton);
    }
    // 
    // SettingsViewMixin implementation.
    getAssociatedControlFor(childViewId) {
        assert(childViewId === 'editDictionary');
        const control = this.shadowRoot.querySelector('#spellCheckSubpageTrigger');
        assert(control);
        return control;
    }
}
customElements.define(SettingsSpellCheckPageElement.is, SettingsSpellCheckPageElement);
