import 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import '/shared/settings/prefs/prefs.js';
import '../settings_shared.css.js';
import './languages_page.js';
import './spell_check_page.js';
import type { CrViewManagerElement } from 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route, SettingsRoutes } from '../router.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
import type { LanguagesModel } from './languages_types.js';
export interface SettingsLanguagesPageIndexElement {
    $: {
        viewManager: CrViewManagerElement;
    };
}
declare const SettingsLanguagesPageIndexElementBase: typeof PolymerElement & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("../settings_page/searchable_view_container_mixin.js").SearchableViewContainerMixinInterface);
export declare class SettingsLanguagesPageIndexElement extends SettingsLanguagesPageIndexElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: ObjectConstructor;
        languages: ObjectConstructor;
        routes_: {
            type: ObjectConstructor;
            value: () => SettingsRoutes;
        };
    };
    prefs: {
        [key: string]: any;
    };
    languages?: LanguagesModel;
    private routes_;
    private showDefaultViews_;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-languages-page-index': SettingsLanguagesPageIndexElement;
    }
}
export {};
