/**
 * @fileoverview 'settings-add-languages-dialog' is a dialog for enabling
 * languages.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_search_field/cr_search_field.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import '../controls/settings_checkbox_list_entry.js';
import '../settings_shared.css.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrSearchFieldElement } from 'chrome://resources/cr_elements/cr_search_field/cr_search_field.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsAddLanguagesDialogElement {
    $: {
        dialog: CrDialogElement;
        search: CrSearchFieldElement;
    };
}
declare const SettingsAddLanguagesDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("//resources/cr_elements/find_shortcut_manager.js").FindShortcutListener) & (new (...args: any[]) => import("../scrollable_mixin.js").ScrollableMixinInterface);
export declare class SettingsAddLanguagesDialogElement extends SettingsAddLanguagesDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        languages: ObjectConstructor;
        languagesToAdd_: {
            type: ObjectConstructor;
            value(): Set<unknown>;
        };
        disableActionButton_: {
            type: BooleanConstructor;
            value: boolean;
        };
        filterValue_: {
            type: StringConstructor;
            value: string;
        };
    };
    languages: chrome.languageSettingsPrivate.Language[];
    private languagesToAdd_;
    private disableActionButton_;
    private filterValue_;
    connectedCallback(): void;
    handleFindShortcut(_modalContextOpen: boolean): boolean;
    searchInputHasFocus(): boolean;
    private onSearchChanged_;
    /** @return A list of languages to be displayed. */
    private getLanguages_;
    /** @return The number of languages to be displayed. */
    private getLanguagesCount_;
    /** @return A 1-based index for aria-posinset. */
    private getAriaPosinset_;
    private getDisplayText_;
    /**
     * @return Whether the user has chosen to add this language (checked its
     *     checkbox).
     */
    private willAdd_;
    /** Handler for checking or unchecking a language item. */
    private onLanguageCheckboxChange_;
    private onCancelButtonClick_;
    /** Enables the checked languages. */
    private onActionButtonClick_;
    private onKeydown_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-add-languages-dialog': SettingsAddLanguagesDialogElement;
    }
}
export {};
