/**
 * 'settings-dropdown-menu' is a control for displaying options
 * in the settings.
 *
 * Example:
 *
 *   <settings-dropdown-menu pref="{{prefs.foo}}">
 *   </settings-dropdown-menu>
 */
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/md_select.css.js';
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
/**
 * |name| is shown in the UI. |value| is used to set or compare with the
 * preference value. |hidden| specifies whether to hide this option from the
 * user.
 */
interface DropdownMenuOption {
    name: string;
    value: number | string;
    hidden?: boolean;
}
export type DropdownMenuOptionList = DropdownMenuOption[];
export interface SettingsDropdownMenuElement {
    $: {
        dropdownMenu: HTMLSelectElement;
    };
}
declare const SettingsDropdownMenuElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/controls/pref_control_mixin.js").PrefControlMixinInterface) & (new (...args: any[]) => import("/shared/settings/controls/cr_policy_pref_mixin.js").CrPolicyPrefMixinInterface);
export declare class SettingsDropdownMenuElement extends SettingsDropdownMenuElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * List of options for the drop-down menu.
         */
        menuOptions: ArrayConstructor;
        /** Whether the dropdown menu should be disabled. */
        disabled: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        /**
           If this is a dictionary pref, this is the key for the item
            we are interested in.
         */
        prefKey: {
            type: StringConstructor;
            value: null;
        };
        /**
         * If true, do not automatically set the preference value. This allows the
         * container to confirm the change first then call either sendPrefChange
         * or resetToPrefValue accordingly.
         */
        noSetPref: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * The value of the "custom" item.
         */
        notFoundValue: {
            type: StringConstructor;
            value: string;
            readOnly: boolean;
        };
        /** Label for a11y purposes */
        label: StringConstructor;
    };
    static get observers(): string[];
    menuOptions: DropdownMenuOptionList;
    disabled: boolean;
    prefKey: string | null;
    noSetPref: boolean;
    notFoundValue: string;
    label: string;
    focus(): void;
    /** Update the pref to the current selected value. */
    sendPrefChange(): void;
    /**
     * Allow access to the selected value without having to go through the shadow
     * dom.
     */
    getSelectedValue(): string;
    /**
     * Pass the selection change to the pref value.
     */
    private onChange_;
    /**
     * Updates the selected item when the pref or menuOptions change.
     */
    private updateSelected_;
    /**
     * Gets the current value of the preference as a string.
     */
    private prefStringValue_;
    private showNotFoundValue_;
    private shouldDisableMenu_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-dropdown-menu': SettingsDropdownMenuElement;
    }
}
export {};
