/**
 * @fileoverview 'settings-checkbox-list-entry' is a wrapper for cr-checkbox so
 * that it can have the correct accessibility behavior while inside an
 * iron-list. Because cr-checkbox passes its focus to its inner checkbox
 * element, screen readers are unable to infer a parent-child relationship
 * between the list element and the focused checkbox. As a result using the
 * roles listbox/option and annotating with aria-setsize/aria-posinset will not
 * work properly.
 *
 * To fix this 'settings-checkbox-list-entry' hijacks focus and prevents it from
 * going into the inner element, so that screenreaders will properly read
 * "(x of y)". This however changes the visuals so that when the element is
 * focused the entire row is highlighted instead of just the checkbox.
 *
 * Example usage:
 * <iron-list role="listbox" items="[[items]]">
 *   <template>
 *     <settings-checkbox-list-entry role="option"
 *         checked="[[isSelected_(item)]]"
 *         tabindex="[[tabIndex]]"
 *         aria-posinset$="[[addOneTo_(index)]]"
 *         aria-setsize$="[[items.length]]"
 *         on-change="toggleSelection_">
 *       [[item]]
 *     </settings-checkbox-list-entry>
 *   </template>
 * </iron-list>
 */
import 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import '../settings_shared.css.js';
import '../site_favicon.js';
import type { CrCheckboxElement } from 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsCheckboxListEntryElement {
    $: {
        checkbox: CrCheckboxElement;
    };
}
export declare class SettingsCheckboxListEntryElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        checked: {
            type: BooleanConstructor;
            value: boolean;
            observer: string;
        };
        tabindex: {
            type: NumberConstructor;
            value: number;
            observer: string;
            reflectToAttribute: boolean;
        };
    };
    checked: boolean;
    private tabindex;
    ready(): void;
    private onClick_;
    private onKeyDown_;
    private onKeyUp_;
    private onCheckedChanged_;
    private onTabIndexChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-checkbox-list-entry': SettingsCheckboxListEntryElement;
    }
}
