/**
 * @fileoverview 'settings-clear-browsing-data-time-picker' is a control that
 * displays time period options for 'settings-clear-browsing-data-dialog-v2'.
 */
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_chip/cr_chip.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { TimePeriod } from './clear_browsing_data_browser_proxy.js';
export declare function getTimePeriodString(timePeriod: TimePeriod, short?: boolean): string;
export interface SettingsClearBrowsingDataTimePicker {
    $: {
        moreButton: HTMLButtonElement;
        moreTimePeriodsMenu: CrLazyRenderElement<CrActionMenuElement>;
        timePicker: HTMLElement;
    };
}
declare const SettingsClearBrowsingDataTimePickerBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface);
export declare class SettingsClearBrowsingDataTimePicker extends SettingsClearBrowsingDataTimePickerBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        selectedTimePeriod_: {
            type: NumberConstructor;
            observer: string;
            value: TimePeriod;
        };
        /**
         * The list of all available Time Periods ordered by duration in ascending
         * order.
         */
        allTimePeriodList_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value: TimePeriod[];
        };
        /**
         * The list of Time Period options that are expanded by default, these
         * should include the currently selected time period.
         */
        expandedOptionList_: {
            type: ArrayConstructor;
            computed: string;
        };
        /**
         * The list of Time Period options that are hidden in the 'More' dropdown
         * menu.
         */
        moreOptionList_: {
            type: ArrayConstructor;
            computed: string;
        };
        /**
           Maximum number of expanded chips to be shown, this should be less than
           or equal to the `allTimePeriodList_.length` and greater than 0.
         */
        maxChipsShown_: {
            type: NumberConstructor;
            value: number;
        };
    };
    static get observers(): string[];
    private selectedTimePeriod_;
    private allTimePeriodList_;
    private expandedOptionList_;
    private moreOptionList_;
    private maxChipsShown_;
    private onTimePeriodPrefUpdated_;
    private onTimePeriodSelectionChanged_;
    private computeExpandedOptionList_;
    private computeMoreOptionList_;
    private onTimePickerDomChanged_;
    private isTimePeriodSelected_;
    private onTimePeriodSelected_;
    private onMenuTimePeriodSelected_;
    private onMoreTimePeriodsButtonClick_;
    private onMoreOptionsMenuClose_;
    getSelectedTimePeriod(): TimePeriod;
    sendPrefChange(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-clear-browsing-data-time-picker': SettingsClearBrowsingDataTimePicker;
    }
}
export {};
