/**
 * @fileoverview 'settings-clear-browsing-data-dialog' allows the user to
 * delete browsing data that has been cached by Chromium.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import 'chrome://resources/cr_elements/cr_tabs/cr_tabs.js';
import './history_deletion_dialog.js';
import './passwords_deletion_dialog.js';
import '../controls/settings_checkbox.js';
import '../icons.html.js';
import '../settings_shared.css.js';
import '../people_page/sync_account_control.js';
import type { SyncStatus } from '/shared/settings/people_page/sync_browser_proxy.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrPageSelectorElement } from 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import type { CrTabsElement } from 'chrome://resources/cr_elements/cr_tabs/cr_tabs.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsCheckboxElement } from '../controls/settings_checkbox.js';
import type { Route } from '../router.js';
import { TimePeriod } from './clear_browsing_data_browser_proxy.js';
export interface SettingsClearBrowsingDataDialogElement {
    $: {
        clearBrowsingDataConfirm: HTMLElement;
        cookiesCheckbox: SettingsCheckboxElement;
        cookiesCheckboxBasic: SettingsCheckboxElement;
        clearButton: CrButtonElement;
        clearBrowsingDataDialog: CrDialogElement;
        pages: CrPageSelectorElement;
        tabs: CrTabsElement;
    };
}
declare const SettingsClearBrowsingDataDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface);
export declare class SettingsClearBrowsingDataDialogElement extends SettingsClearBrowsingDataDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The current sync status, supplied by SyncBrowserProxy.
         */
        syncStatus: ObjectConstructor;
        /**
         * Results of browsing data counters, keyed by the suffix of
         * the corresponding data type deletion preference, as reported
         * by the C++ side.
         */
        counters_: {
            type: ObjectConstructor;
            value(): {};
        };
        /**
         * List of options for the dropdown menu.
         */
        clearFromOptions_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value: {
                value: TimePeriod;
                name: string;
            }[];
        };
        clearingInProgress_: {
            type: BooleanConstructor;
            value: boolean;
        };
        clearingDataAlertString_: {
            type: StringConstructor;
            value: string;
        };
        clearButtonDisabled_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showHistoryDeletionDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showPasswordsDeletionDialogLater_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showPasswordsDeletionDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        isSyncingHistory_: {
            type: BooleanConstructor;
            value: boolean;
        };
        shouldShowCookieException_: {
            type: BooleanConstructor;
            value: boolean;
        };
        isClearPrimaryAccountAllowed_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        isSyncPaused_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        hasPassphraseError_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        hasOtherSyncError_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        selectedTabIndex_: NumberConstructor;
        tabsNames_: {
            type: ArrayConstructor;
            value: () => string[];
        };
        googleSearchHistoryString_: {
            type: StringConstructor;
            computed: string;
        };
        isNonGoogleDse_: {
            type: BooleanConstructor;
            value: boolean;
        };
        nonGoogleSearchHistoryString_: StringConstructor;
    };
    static get observers(): string[];
    syncStatus: SyncStatus | undefined;
    private counters_;
    private clearFromOptions_;
    private clearingInProgress_;
    private clearingDataAlertString_;
    private clearButtonDisabled_;
    private showHistoryDeletionDialog_;
    private showPasswordsDeletionDialogLater_;
    private showPasswordsDeletionDialog_;
    private isSyncingHistory_;
    private shouldShowCookieException_;
    private isClearPrimaryAccountAllowed_;
    private isSyncPaused_;
    private hasPassphraseError_;
    private hasOtherSyncError_;
    private selectedTabIndex_;
    private tabsNames_;
    private googleSearchHistoryString_;
    private isNonGoogleDse_;
    private nonGoogleSearchHistoryString_;
    private focusOutlineManager_;
    private browserProxy_;
    private syncBrowserProxy_;
    ready(): void;
    connectedCallback(): void;
    /**
     * Handler for when the sync state is pushed from the browser.
     */
    private handleSyncStatus_;
    /**
     * @return Whether either clearing is in progress or no data type is selected.
     */
    private isClearButtonDisabled_;
    /**
     * Disables the Clear Data button if no data type is selected.
     */
    private updateClearButtonState_;
    /**
     * Record visits to the CBD dialog.
     *
     * RouteObserverMixin
     */
    currentRouteChanged(currentRoute: Route): void;
    /**
     * Updates the history description to show the relevant information
     * depending on sync and signin state.
     */
    private updateSyncState_;
    /** Choose a label for the history checkbox. */
    private browsingCheckboxLabel_;
    /**
     * Choose a label for the cookie checkbox
     * @param signedInState SignedInState
     * @param shouldShowCookieException boolean whether the exception about not
     * being signed out of your Google account should be shown when user is
     * sync.
     * @param cookiesSummary string explaining that deleting cookies and site data
     * will sign the user out of most websites.
     * @param clearCookiesSummarySignedIn string explaining that deleting cookies
     * and site data will sign the user out of most websites but Google sign in
     * will stay.
     * @param clearCookiesSummarySyncing string explaining that deleting cookies
     * and site data will sign the user out of most websites but Google sign in
     * will stay when user is syncing.
     * @param clearCookiesSummarySignedInSupervisedProfile string used for a
     * supervised user. Gives information about family link controls and that they
     * will not be signed out on clearing cookies
     */
    private cookiesCheckboxLabel_;
    /**
     * Updates the text of a browsing data counter corresponding to the given
     * preference.
     * @param prefName Browsing data type deletion preference.
     * @param text The text with which to update the counter
     */
    private updateCounterText_;
    /**
     * @return A list of selected data types.
     */
    private getSelectedDataTypes_;
    private getTimeRangeDropdownForCurrentPage_;
    private isBasicTabSelected_;
    /** Clears browsing data and maybe shows a history notice. */
    private clearBrowsingData_;
    private onCancelClick_;
    /**
     * Handles the closing of the notice about other forms of browsing history.
     */
    private onHistoryDeletionDialogClose_;
    /**
     * Handles the closing of the notice about incomplete passwords deletion.
     */
    private onPasswordsDeletionDialogClose_;
    private onSelectedTabIndexPrefUpdated_;
    /**
     * Records an action when the user changes between the basic and advanced tab.
     */
    private recordTabChange_;
    /** Called when the user clicks the link in the footer. */
    private onSyncDescriptionLinkClicked_;
    private computeIsSyncPaused_;
    private computeHasPassphraseError_;
    private computeHasOtherError_;
    private computeGoogleSearchHistoryString_;
    private shouldShowFooter_;
    /**
     * @return Whether the signed info description should be shown in the footer.
     */
    private showSigninInfo_;
    /**
     * @return Whether the synced info description should be shown in the footer.
     */
    private showSyncInfo_;
    /**
     * @return Whether the search history box should be shown.
     */
    private showSearchHistoryBox_;
    private onTimePeriodChanged_;
    private onTimePeriodAdvancedPrefUpdated_;
    private onTimePeriodBasicPrefUpdated_;
    private onTimePeriodPrefUpdated_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-clear-browsing-data-dialog': SettingsClearBrowsingDataDialogElement;
    }
}
export {};
