/**
 * @fileoverview 'iban-list-entry' is an IBAN row to be shown on the settings
 * page.
 */
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../i18n_setup.js';
import '../settings_shared.css.js';
import './passwords_shared.css.js';
import './screen_reader_only.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export type DotsIbanMenuClickEvent = CustomEvent<{
    iban: chrome.autofillPrivate.IbanEntry;
    anchorElement: HTMLElement;
}>;
export type RemoteIbanMenuClickEvent = CustomEvent<{
    iban: chrome.autofillPrivate.IbanEntry;
    anchorElement: HTMLElement;
}>;
declare global {
    interface HTMLElementEventMap {
        'dots-iban-menu-click': DotsIbanMenuClickEvent;
        'remote-iban-menu-click': RemoteIbanMenuClickEvent;
    }
}
declare const SettingsIbanListEntryElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsIbanListEntryElement extends SettingsIbanListEntryElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /** A saved IBAN. */
        iban: ObjectConstructor;
        showNewFopDisplayEnabled_: {
            type: BooleanConstructor;
            value(): boolean;
            readOnly: boolean;
        };
    };
    iban: chrome.autofillPrivate.IbanEntry;
    private showNewFopDisplayEnabled_;
    get dotsMenu(): HTMLElement | null;
    /**
     * The 3-dot menu should be shown if the IBAN is a local IBAN.
     */
    private showDotsMenu_;
    /**
     * The Google Payments icon should be shown if the IBAN is a server IBAN.
     */
    private shouldShowGooglePaymentsIndicator_;
    /**
     * This function returns a string that can be used in a srcset to scale
     * the provided `url` based on the user's screen resolution.
     */
    private getScaledSrcSet_;
    /**
     * Opens the IBAN action menu.
     */
    private onDotsMenuClick_;
    private onRemoteEditClick_;
    private getA11yIbanDescription_;
    private getIbanImageSrc_;
    private getLabel_;
    private getSubLabel_;
    /**
     * @return the title for the More Actions button corresponding to the IBAN
     *     which is described by the nickname or last 4 digits of the IBAN's
     *     value.
     */
    private getMoreActionsTitle_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-iban-list-entry': SettingsIbanListEntryElement;
    }
}
export {};
