import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">:host{--about-page-image-space:10px}.info-sections{padding:var(--cr-section-vertical-padding) var(--cr-section-padding)}.info-section{margin-bottom:12px}.product-title{font-size:153.85%;font-weight:400;margin-bottom:auto;margin-top:auto}#product-logo{margin-inline-end:var(--about-page-image-space)}.icon-container{margin-inline-end:var(--about-page-image-space);min-width:32px;text-align:center}cr-icon[icon='cr:check-circle']{fill:var(--cr-checked-color)}cr-icon[icon='cr:error']{fill:var(--settings-error-color)}#throbber{height:var(--cr-icon-size);vertical-align:middle}cr-button{white-space:nowrap}
    </style>
    <settings-section page-title="$i18n{aboutPageTitle}">
      <div class="cr-row two-line first">
        <img id="product-logo" on-click="onProductLogoClick_"
            srcset="chrome://theme/current-channel-logo@1x 1x,
                    chrome://theme/current-channel-logo@2x 2x"
            alt="$i18n{aboutProductLogoAlt}"
            role="presentation">
        <div class="product-title">$i18n{aboutProductTitle}</div>
      </div>
      <div class="cr-row two-line">
        <!-- Set the icon from the iconset (when it's obsolete/EOL and
          when update is done) or set the src (when it's updating). -->

        <div class="icon-container"
            hidden="[[!shouldShowIcons_(showUpdateStatus_)]]">
          <cr-icon
              hidden="[[shouldShowThrobber_(
                  obsoleteSystemInfo_, currentUpdateStatusEvent_)]]"
              icon$="[[getUpdateStatusIcon_(
                  obsoleteSystemInfo_, currentUpdateStatusEvent_)]]">
          </cr-icon>
          <img id="throbber" src="chrome://resources/images/throbber_small.svg"
              hidden="[[!shouldShowThrobber_(
                  obsoleteSystemInfo_, currentUpdateStatusEvent_)]]">
        </div>

        <div class="flex cr-padded-text">

          <div id="updateStatusMessage" hidden="[[!showUpdateStatus_]]">
            <div role="alert" aria-live="polite"
                inner-h-t-m-l="[[getUpdateStatusMessage_(
                    currentUpdateStatusEvent_)]]">
            </div>
            <a hidden$="[[!shouldShowLearnMoreLink_(
                currentUpdateStatusEvent_)]]" target="_blank"
                href="https://support.google.com/chrome?p=update_error"
                aria-label="$i18nPolymer{aboutLearnMoreUpdatingErrors}">
              $i18n{learnMore}
            </a>
          </div>
          <span id="deprecationWarning"
              hidden="[[!obsoleteSystemInfo_.obsolete]]">
            $i18n{aboutObsoleteSystem}
            <a href="$i18n{aboutObsoleteSystemURL}" target="_blank"
                aria-label="$i18nPolymer{aboutLearnMoreSystemRequirements}">
              $i18n{learnMore}
            </a>
          </span>

          <div class="secondary">$i18n{aboutBrowserVersion}</div>
        </div>

        <div class="separator" hidden="[[!showButtonContainer_]]"></div>
        <span id="buttonContainer" hidden="[[!showButtonContainer_]]">
          <cr-button id="relaunch" hidden="[[!showRelaunch_]]"
              on-click="onRelaunchClick_">
            $i18n{aboutRelaunch}
          </cr-button>
        </span>

      </div>

      <cr-link-row class="hr" id="help" on-click="onHelpClick_"
          label="$i18n{aboutGetHelpUsingChrome}"
          external></cr-link-row>

      <cr-link-row class="hr" on-click="onManagementPageClick_"
          start-icon="[[managedByIcon_]]" label="$i18n{managementPage}"
          role-description="$i18n{subpageArrowRoleDescription}"
          hidden$="[[!isManaged_]]"></cr-link-row>
    </settings-section>

    <settings-section>
      <div class="info-sections">
        <div class="info-section">
          <div class="secondary">$i18n{aboutProductTitle}</div>
          <div class="secondary">$i18n{aboutProductCopyright}</div>
        </div>

        <div class="info-section">
          <div class="secondary">$i18nRaw{aboutProductLicense}</div>
        </div>


  <template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
    <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RELAUNCH]]"
        on-close="onRelaunchDialogClose"></relaunch-confirmation-dialog>
  </template>

      </div>
    </settings-section>
<!--_html_template_end_-->`;
}
