/**
 * @fileoverview 'settings-live-caption' is a component for showing Live Caption
 * settings. It appears on the accessibility subpage
 * (chrome://settings/accessibility) on Mac and some versions of Windows and on
 * the captions subpage (chrome://settings/captions) on Linux and other versions
 * of Windows.
 */
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_collapse/cr_collapse.js';
import '../controls/settings_toggle_button.js';
import '../settings_shared.css.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import type { CrActionMenuElement } from '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import './live_translate_section.js';
import '../languages_page/add_languages_dialog.js';
declare const SettingsLiveCaptionElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/list_property_update_mixin.js").ListPropertyUpdateMixinInterface) & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export interface SettingsLiveCaptionElement {
    $: {
        menu: CrLazyRenderElement<CrActionMenuElement>;
    };
}
export declare class SettingsLiveCaptionElement extends SettingsLiveCaptionElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The subtitle to display under the Live Caption heading. Generally, this
         * is a generic subtitle describing the feature. While the SODA model is
         * being downloading, this displays the download progress.
         */
        enableLiveCaptionSubtitle_: {
            type: StringConstructor;
            value: string;
        };
        enableLiveCaptionMultiLanguage_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        enableLiveTranslate_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        installedLanguagePacks_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        availableLanguagePacks_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        /**
         * The language to display the details for.
         */
        detailLanguage_: ObjectConstructor;
        showAddLanguagesDialog_: BooleanConstructor;
    };
    private enableLiveTranslate_;
    private installedLanguagePacks_;
    private availableLanguagePacks_;
    private detailLanguage_?;
    private showAddLanguagesDialog_;
    private browserProxy_;
    private enableLiveCaptionSubtitle_;
    private enableLiveCaptionMultiLanguage_;
    ready(): void;
    /**
     * @return the Live Caption toggle element.
     */
    getLiveCaptionToggle(): SettingsToggleButtonElement;
    protected computeMoreButtonAriaLabel_(name: string, code: string): string;
    private onLiveCaptionEnabledChanged_;
    private onLiveCaptionMaskOffensiveWordsChanged_;
    private onAddLanguagesClick_;
    private onAddLanguagesDialogClose_;
    private onDotsClick_;
    private isDefaultLanguage_;
    private onMakeDefaultClick_;
    private onRemoveLanguageClick_;
    private onLanguagesAdded_;
    private installLanguagePacks_;
    private filterAvailableLanguagePacks_;
    /**
     * Displays SODA download progress in the UI. When the language UI is visible,
     * which occurs when the kLiveCaptionMultiLanguage feature is enabled and when
     * the kLiveCaptionEnabled pref is true, download progress should appear next
     * to the selected language. Otherwise, the download progress appears as a
     * subtitle below the Live Caption toggle.
     * @param sodaDownloadProgress The message sent from the webui to be displayed
     *     as download progress for Live Caption.
     * @param languageCode The language code indicating which language pack the
     *     message applies to.
     */
    private onSodaDownloadProgressChangedForLanguage_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-live-caption': SettingsLiveCaptionElement;
    }
}
export {};
