import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->  <style include="settings-shared">:host{display:block}.zoom-label{color:var(--cr-secondary-text-color);margin-inline-end:16px}#empty{margin-top:15px}.list-item site-favicon{flex-shrink:0}.list-item .middle{overflow-x:hidden;text-overflow:ellipsis}.content-settings-header{padding:0 var(--cr-section-padding)}
  </style>
  <settings-subpage page-title="$i18n{siteSettingsCategoryZoomLevels}">
    <div class="content-settings-header secondary">
      $i18n{siteSettingsZoomLevelsDescription}
    </div>
    <div class="list-frame vertical-list" id="listContainer">
      <iron-list id="list" preserve-focus items="[[sites_]]"
          class="cr-separators" risk-selection>
        <template>
          <div class="list-item" first$="[[!index]]">
            <site-favicon url="[[item.originForFavicon]]"></site-favicon>
            <div class="middle">
              <span class="url-directionality">[[item.displayName]]</span>
            </div>
            <div class="zoom-label">[[item.zoom]]</div>
            <cr-icon-button class="icon-clear" on-click="removeZoomLevel_"
                title="$i18n{siteSettingsRemoveZoomLevel}"
                tabindex$="[[tabIndex]]"></cr-icon-button>
          </div>
        </template>
      </iron-list>
      <div id="empty" hidden$="[[!showNoSites_]]">
        $i18n{siteSettingsNoZoomedSites}
      </div>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`;
}