import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{--favicon-size:0}#search-wrapper{align-items:center;display:flex;min-height:var(--cr-section-min-height)}.default-search-engine .cr-row{--cr-section-min-height:55px;gap:12px;padding:0}.default-search-engine{padding-top:var(--cr-section-vertical-padding)}.search-engine-name{margin-inline-end:auto}site-favicon{--site-favicon-border-radius:4px;--site-favicon-height:var(--favicon-size);--site-favicon-width:var(--favicon-size)}settings-search-engine-list-dialog{--search-engine-icon-size:var(--favicon-size)}
</style>
<settings-section page-title="$i18n{searchPageTitle}">
  <div route-path="default">
    <!-- Omnibox search engine -->
    <div class="cr-row first">
      <div class="default-search-engine flex">
        $i18n{searchPageTitle}
        <div class="secondary">
          $i18n{searchEngineChoiceEntryPointSubtitle}
          <a href="$i18n{searchExplanationLearnMoreURL}"
              aria-description="$i18n{opensInNewTab}"
              aria-label="$i18n{searchExplanationLearnMoreA11yLabel}"
              target="_blank">
            $i18n{learnMore}
          </a>
        </div>
        <template is="dom-if" if="[[isDefaultSearchControlledByPolicy_(
            prefs.default_search_provider_data.template_url_data)]]">
          <cr-policy-pref-indicator pref="[[
              prefs.default_search_provider_data.template_url_data]]">
          </cr-policy-pref-indicator>
        </template>
        <div class="cr-row first">
          <site-favicon favicon-url="[[defaultSearchEngine_.iconURL]]"
              url="[[defaultSearchEngine_.url]]"
              icon-path="[[defaultSearchEngine_.iconPath]]">
          </site-favicon>
          <div class="search-engine-name">[[defaultSearchEngine_.name]]</div>
          <cr-button id="openDialogButton"
              on-click="onOpenDialogButtonClick_"
              disabled$="[[isDefaultSearchEngineEnforced_(
                  prefs.default_search_provider_data.template_url_data)]]">
            $i18n{searchEnginesChange}
          </cr-button>
        </div>
      </div>
      <template is="dom-if" if="[[showSearchEngineListDialog_]]" restamp>
        <settings-search-engine-list-dialog
            search-engines="[[searchEngines_]]"
            on-close="onSearchEngineListDialogClose_"
            on-search-engine-changed="onDefaultSearchEngineChangedInDialog_">
        </settings-search-engine-list-dialog>
      </template>
      <cr-toast id="confirmationToast" duration="10000">
        <div>[[confirmationToastLabel_]]</div>
      </cr-toast>
    </div>
    <template is="dom-if"
        if="[[prefs.default_search_provider_data.template_url_data.extensionId]]">
      <div class="cr-row continuation">
        <extension-controlled-indicator
            class="flex"
            extension-id="[[
                prefs.default_search_provider_data.template_url_data.extensionId]]"
            extension-name="[[
                prefs.default_search_provider_data.template_url_data.controlledByName]]"
            extension-can-be-disabled="[[
                prefs.default_search_provider_data.template_url_data.extensionCanBeDisabled]]"
            on-disable-extension="onDisableExtension_">
        </extension-controlled-indicator>
      </div>
    </template>

    <!-- Manage search engines -->
    <cr-link-row class="hr" id="enginesSubpageTrigger"
        label="$i18n{searchEnginesManageSiteSearch}"
        on-click="onManageSearchEnginesClick_"
        role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
  </div>
</settings-section>
<!--_html_template_end_-->`;
}