import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="settings-shared">#headers{display:flex;padding:10px 0}#headers .additional-info-column-group{align-items:center;display:flex;flex:6}#headers .controls-group{flex:auto;margin-left:auto;display:flex;justify-content:end;align-items:center}#headers .name{flex:3}#headers .shortcut,#headers .url{flex:auto;margin-inline-end:40px}settings-search-engine-entry{border-top:var(--cr-separator-line)}:host([fixed-height]) #container{max-height:calc((var(--cr-section-min-height) + var(--cr-separator-height)) * 6)}.icon-placeholder{margin-inline-end:0;margin-inline-start:var(--cr-icon-button-margin-start);width:var(--cr-icon-ripple-size)}.cr-row{padding-inline-end:7px;padding-inline-start:0}
    </style>
    <div id="outer" class="list-frame" role="table">
      <div role="rowgroup">
        <div role="row" id="headers" class="column-header">
          <span class="name" role="columnheader">$i18n{searchEnginesName}</span>
          <span class="additional-info-column-group">
            <span class="shortcut" role="columnheader"
                  hidden="[[!showShortcut]]">
              $i18n{searchEnginesShortcut}
            </span>
            <span class="url" role="columnheader"
                  hidden="[[!showQueryUrl]]">
              $i18n{searchEnginesQueryURL}
            </span>
            <span class="controls-group">
              <span class="icon-placeholder"></span>
              <span class="icon-placeholder"></span>
            </span>
          </span>
        </div>
      </div>
      <template is="dom-if" if="[[!collapseList]]">
        <div id="container" class="scroll-container"
            scrollable$="[[fixedHeight]]">
          <div role="rowgroup">
            <dom-repeat items="[[engines]]">
              <template>
                <settings-search-engine-entry engine="[[item]]"
                    show-query-url="[[showQueryUrl]]"
                    show-shortcut="[[showShortcut]]">
                </settings-search-engine-entry>
              </template>
            </dom-repeat>
          </div>
        </div>
      </template>

      <template is="dom-if" if="[[collapseList]]">
        <div id="containerWithCollapsibleSection" class="scroll-container"
            hidden="[[!collapseList]]"
            scrollable$="[[fixedHeight]]">
          <div role="rowgroup">
            <dom-repeat items="[[visibleEngines]]">
              <template>
                <settings-search-engine-entry engine="[[item]]"
                    show-shortcut="[[showShortcut]]"
                    show-query-url="[[showQueryUrl]]">
                </settings-search-engine-entry>
              </template>
            </dom-repeat>
          </div>

          <cr-expand-button no-hover class="cr-row"
              hidden="[[!collapsedEngines.length]]"
              expanded="{{enginesListExpanded_}}">
            <div>[[expandListText]]</div>
          </cr-expand-button>
          <cr-collapse opened="[[enginesListExpanded_]]">
            <div role="rowgroup">
              <dom-repeat items="[[collapsedEngines]]">
                <template>
                  <settings-search-engine-entry engine="[[item]]"
                      show-shortcut="[[showShortcut]]"
                      show-query-url="[[showQueryUrl]]">
                  </settings-search-engine-entry>
                </template>
              </dom-repeat>
            </div>
          </cr-collapse>
        </div>
      </template>
    </div>
<!--_html_template_end_-->`;
}