import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">#explanationText{padding:4px var(--cr-section-padding) 12px}.outer-row{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height);width:100%}.topic-toggle-row:hover{background-color:var(--cr-hover-background-color)}.topic-toggle-row{--cr-icon-button-margin-end:20px;padding:0 var(--cr-section-padding)}.icon{margin-inline-end:var(--cr-icon-button-margin-end)}.label-wrapper{padding:16px 0;margin-inline-end:20px}
</style>
<settings-subpage page-title="$i18n{manageTopicsHeading}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
  <div id="explanationText">
    $i18n{manageTopicsPageDescription}
    <span id="learnMoreLink" on-click="onLearnMoreClick_">
      $i18nRaw{manageTopicsPageLearnMoreLink}
    </span>
  </div>
  <template is="dom-repeat" items="[[firstLevelTopicsList_]]">
    <div class="topic-toggle-row" on-click="onToggleRowClick_" actionable>
      <div class="outer-row">
        <span class="icon">
          <cr-icon slot="icon"
              icon="[[computeTopicIcon_(item.topic.topicId)]]">
          </cr-icon>
        </span>
        <div class="flex label-wrapper">
          <div class="label">[[item.topic.displayString]]</div>
          <div class="cr-secondary-text sub-label">
            <span class="sub-label-text">[[item.topic.description]]</span>
          </div>
        </div>
        <cr-toggle id="toggle-[[item.topic.topicId]]"
            on-change="onToggleChange_"
            checked="[[!item.removed]]"
            aria-label="[[item.topic.displayString]]"
            aria-description="[[item.topic.description]]"></cr-toggle>
      </div>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowBlockTopicDialog_]]" restamp>
    <settings-simple-confirmation-dialog id="blockTopicDialog"
        title-text="[[blockTopicDialogTitle_]]"
        body-text="[[blockTopicDialogBody_]]"
        confirm-text="$i18n{topicsPageBlockTopic}"
        on-close="onBlockTopicDialogClose_">
    </settings-simple-confirmation-dialog>
  </template>
</settings-subpage>
<!--_html_template_end_-->`;
}