import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style>cr-tabs{--cr-tabs-font-size:100%;--cr-tabs-height:40px}#dialog{--border-top-color:var(--google-grey-300);--cr-dialog-body-border-top:1px solid var(--border-top-color)}@media (prefers-color-scheme:dark){#dialog{--border-top-color:var(--cr-separator-color)}}#dialog::part(wrapper){overflow:hidden}#dialog [slot=title]{padding-bottom:8px}#dialog::part(body-container){height:calc(5 * var(--cr-section-min-height) + 2px)}#body{padding-inline-end:0;padding-inline-start:0}#helpText{padding-bottom:20px}#helpText>a{color:var(--cr-link-color)}#inputPage{padding-inline-end:20px;padding-inline-start:20px;padding-top:20px}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{addSitesTitle}</div>
  <div slot="header">
    <cr-tabs id="tabs" tab-names="[[tabNames_]]" selected="{{selectedTab_}}">
    </cr-tabs>
  </div>
  <div id="body" slot="body">
    <cr-page-selector selected="[[selectedTab_]]"
        on-iron-select="onSelectedTabChanged_">
      <tab-discard-exception-current-sites-list id="list" prefs="{{prefs}}"
          on-sites-populated="onSitesPopulated_"
          visible="[[isAddCurrentSitesTabSelected_(selectedTab_)]]"
          submit-disabled="{{submitDisabledList_}}">
      </tab-discard-exception-current-sites-list>
      <div id="inputPage">
        <div id="helpText">
          $i18nRaw{tabDiscardingExceptionsAddDialogHelp}
        </div>
        <tab-discard-exception-add-input id="input" prefs="{{prefs}}"
            submit-disabled="{{submitDisabledManual_}}">
        </tab-discard-exception-add-input>
      </div>
    </cr-page-selector>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="actionButton" class="action-button" on-click="onSubmitClick_"
        disabled$="[[isSubmitDisabled_(
            submitDisabledList_, submitDisabledManual_, selectedTab_)]]"
        aria-label="$i18n{tabDiscardingExceptionsAddButtonAriaLabel}">
      $i18n{add}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}