import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.battery-saver-radio-group{padding-block-end:var(--cr-section-vertical-padding)}</style>
<settings-section

    page-title="$i18n{batteryPageTitle}">
  <template is="dom-if" if="[[isBatterySaverModeManagedByOs_]]">
    <cr-link-row id="batterySaverOSSettingsLinkRow"
        label="$i18n{batterySaverModeLabel}"
        sub-label="$i18n{batterySaverModeLinkOsDescription}"
        on-click="openOsPowerSettings_"
        external>
    </cr-link-row>
  </template>
  <template is="dom-if" if="[[!isBatterySaverModeManagedByOs_]]">
    <settings-toggle-button id="toggleButton" on-change="onChange_"
        pref="{{prefs.performance_tuning.battery_saver_mode.state}}"
        label="$i18n{batterySaverModeLabel}"
        sub-label-with-link="$i18n{batterySaverModeDescription}"
        on-sub-label-link-clicked="onBatterySaverLearnMoreLinkClick_"
        numeric-unchecked-values="[[numericUncheckedValues_]]"
        numeric-checked-value="[[batterySaverModeStateEnum_.ENABLED_BELOW_THRESHOLD]]">
    </settings-toggle-button>
    <cr-collapse id="radioGroupCollapse"
        opened="[[isBatterySaverModeEnabled_(prefs.performance_tuning.battery_saver_mode.state.value)]]">
      <div class="cr-row continuation battery-saver-radio-group">
        <settings-radio-group id="radioGroup" on-change="onChange_"
            pref="{{prefs.performance_tuning.battery_saver_mode.state}}"
            group-aria-label="$i18n{batterySaverModeRadioGroupAriaLabel}">
          <controlled-radio-button
              label="$i18n{batterySaverModeEnabledBelowThresholdLabel}"
              name="[[batterySaverModeStateEnum_.ENABLED_BELOW_THRESHOLD]]"
              pref="[[prefs.performance_tuning.battery_saver_mode.state]]">
          </controlled-radio-button>
          <controlled-radio-button id="enabledOnBatteryButton"
              label="$i18n{batterySaverModeEnabledOnBatteryLabel}"
              name="[[batterySaverModeStateEnum_.ENABLED_ON_BATTERY]]"
              pref="[[prefs.performance_tuning.battery_saver_mode.state]]">
          </controlled-radio-button>
        </settings-radio-group>
      </div>
    </cr-collapse>
  </template>
</settings-section>
<!--_html_template_end_-->`;
}