// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/icons.html.js";import"/strings.m.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{getCss}from"./app.css.js";import{getHtml}from"./app.html.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{MetricsRecorder}from"./metrics_recorder.js";const RELOAD_BUTTON_TOOLTIP_RELOAD_WITH_MENU="reloadButtonTooltipReloadWithMenu";const RELOAD_BUTTON_TOOLTIP_RELOAD="reloadButtonTooltipReload";const RELOAD_BUTTON_TOOLTIP_STOP="reloadButtonTooltipStop";const LONG_PRESS_TIMER_THRESHOLD_MS=500;export class ReloadButtonAppElement extends CrLitElement{browserProxy_;metricsRecorder_;constructor(){super();this.browserProxy_=BrowserProxyImpl.getInstance();this.metricsRecorder_=new MetricsRecorder(this.browserProxy_);const callbackRouter=this.browserProxy_.callbackRouter;callbackRouter.setReloadButtonState.addListener(((isLoading,isMenuEnabled)=>{this.metricsRecorder_.onChangeVisibleMode(MetricsRecorder.getVisibleMode(this.isLoading_),MetricsRecorder.getVisibleMode(isLoading));this.isLoading_=isLoading;this.isMenuEnabled_=isMenuEnabled;this.tooltip_=loadTimeData.getString(isLoading?RELOAD_BUTTON_TOOLTIP_STOP:isMenuEnabled?RELOAD_BUTTON_TOOLTIP_RELOAD_WITH_MENU:RELOAD_BUTTON_TOOLTIP_RELOAD)}));ColorChangeUpdater.forDocument().start()}static get is(){return"reload-button-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{isLoading_:{state:true,type:Boolean},tooltip_:{state:true,type:String}}}#isLoading__accessor_storage=false;get isLoading_(){return this.#isLoading__accessor_storage}set isLoading_(value){this.#isLoading__accessor_storage=value}#tooltip__accessor_storage=loadTimeData.getString(RELOAD_BUTTON_TOOLTIP_RELOAD);get tooltip_(){return this.#tooltip__accessor_storage}set tooltip_(value){this.#tooltip__accessor_storage=value}isLongPressed_=false;longPressTimer_=0;isMenuEnabled_=false;connectedCallback(){super.connectedCallback();this.metricsRecorder_.startObserving()}disconnectedCallback(){super.disconnectedCallback();this.metricsRecorder_.stopObserving()}onReloadButtonPointerDown_(e){if(e.button!==0){return}this.isLongPressed_=false;clearTimeout(this.longPressTimer_);if(this.isLoading_){return}this.longPressTimer_=setTimeout((()=>{this.isLongPressed_=true;if(this.isMenuEnabled_){BrowserProxyImpl.getInstance().handler.showContextMenu(e.offsetX,e.offsetY)}}),LONG_PRESS_TIMER_THRESHOLD_MS)}onReloadButtonPointerUp_(e){this.metricsRecorder_.onButtonPressedStart(e);if(this.isLongPressed_){this.isLongPressed_=false;return}this.metricsRecorder_.onChangeVisibleMode(MetricsRecorder.getVisibleMode(this.isLoading_),MetricsRecorder.getVisibleMode(!this.isLoading_));clearTimeout(this.longPressTimer_);if(this.isLoading_){BrowserProxyImpl.getInstance().handler.stopReload()}else{BrowserProxyImpl.getInstance().handler.reload(e.shiftKey||e.ctrlKey)}this.isLoading_=!this.isLoading_}}customElements.define(ReloadButtonAppElement.is,ReloadButtonAppElement);