import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import '/strings.m.js';
import './shared_style.css.js';
import './privacy_sandbox_dialog_learn_more.js';
import './privacy_sandbox_privacy_policy_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const PrivacySandboxDialogConsentStepElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("./privacy_sandbox_dialog_mixin.js").PrivacySandboxDialogMixinInterface);
export declare class PrivacySandboxDialogConsentStepElement extends PrivacySandboxDialogConsentStepElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        expanded_: {
            type: BooleanConstructor;
            observer: string;
        };
        /**
         * If true, the consent notice page is hidden.
         * On load, this page should not be hidden.
         */
        hideConsentNoticePage_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * If true, the Ad Topics Content parity should be shown.
         */
        shouldShowAdTopicsContentParity_: {
            type: BooleanConstructor;
            value: boolean;
        };
        consentContentV2FirstDescription_: {
            type: StringConstructor;
            computed: string;
        };
    };
    private expanded_;
    private hideConsentNoticePage_;
    private shouldShowAdTopicsContentParity_;
    private consentContentV2FirstDescription_;
    ready(): void;
    private onConsentAccepted_;
    private onConsentDeclined_;
    private onConsentLearnMoreExpanded_;
    private onBackButtonClicked_;
    private onPrivacyPolicyLinkClicked_;
    private computeConsentContentV2FirstDescription_;
}
declare global {
    interface HTMLElementTagNameMap {
        'privacy-sandbox-dialog-consent-step': PrivacySandboxDialogConsentStepElement;
    }
}
export {};
