import 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import '/strings.m.js';
import './shared_style.css.js';
import './privacy_sandbox_dialog_consent_step.js';
import './privacy_sandbox_dialog_notice_step.js';
import type { CrViewManagerElement } from 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare enum PrivacySandboxCombinedDialogStep {
    CONSENT = "consent",
    SAVING = "saving",
    NOTICE = "notice"
}
export interface PrivacySandboxCombinedDialogAppElement {
    $: {
        viewManager: CrViewManagerElement;
    };
}
declare const PrivacySandboxCombinedDialogAppElementBase: typeof PolymerElement & (new (...args: any[]) => import("./privacy_sandbox_dialog_resize_mixin.js").PrivacySandboxDialogResizeMixinInterface);
export declare class PrivacySandboxCombinedDialogAppElement extends PrivacySandboxCombinedDialogAppElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        step_: StringConstructor;
        stepEnum_: {
            type: ObjectConstructor;
            value: typeof PrivacySandboxCombinedDialogStep;
        };
    };
    private step_;
    private animationsEnabled_;
    ready(): void;
    disableAnimationsForTesting(): void;
    private onConsentStepResolved_;
    private navigateToStep_;
    private promptActionOccurred;
    private updateScrollableContentsCurrentStep_;
    private getStepElement_;
}
declare global {
    interface HTMLElementTagNameMap {
        'privacy-sandbox-combined-dialog-app': PrivacySandboxCombinedDialogAppElement;
    }
}
export {};
