// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js";import"chrome://resources/cr_elements/cr_shared_style.css.js";import"chrome://resources/cr_elements/cr_spinner_style.css.js";import"/strings.m.js";import"./shared_style.css.js";import"./privacy_sandbox_dialog_consent_step.js";import"./privacy_sandbox_dialog_notice_step.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./privacy_sandbox_combined_dialog_app.html.js";import{PrivacySandboxDialogBrowserProxy,PrivacySandboxPromptAction}from"./privacy_sandbox_dialog_browser_proxy.js";import{PrivacySandboxDialogResizeMixin}from"./privacy_sandbox_dialog_resize_mixin.js";export var PrivacySandboxCombinedDialogStep;(function(PrivacySandboxCombinedDialogStep){PrivacySandboxCombinedDialogStep["CONSENT"]="consent";PrivacySandboxCombinedDialogStep["SAVING"]="saving";PrivacySandboxCombinedDialogStep["NOTICE"]="notice"})(PrivacySandboxCombinedDialogStep||(PrivacySandboxCombinedDialogStep={}));const PrivacySandboxCombinedDialogAppElementBase=PrivacySandboxDialogResizeMixin(PolymerElement);export class PrivacySandboxCombinedDialogAppElement extends PrivacySandboxCombinedDialogAppElementBase{static get is(){return"privacy-sandbox-combined-dialog-app"}static get template(){return getTemplate()}static get properties(){return{step_:String,stepEnum_:{type:Object,value:PrivacySandboxCombinedDialogStep}}}animationsEnabled_=true;ready(){super.ready();const step=new URLSearchParams(window.location.search).get("step");const startWithNotice=step===PrivacySandboxCombinedDialogStep.NOTICE;const firstStep=startWithNotice?PrivacySandboxCombinedDialogStep.NOTICE:PrivacySandboxCombinedDialogStep.CONSENT;this.navigateToStep_(firstStep).then((()=>this.resizeAndShowNativeDialog())).then((()=>this.promptActionOccurred(startWithNotice?PrivacySandboxPromptAction.NOTICE_SHOWN:PrivacySandboxPromptAction.CONSENT_SHOWN))).then((()=>this.updateScrollableContentsCurrentStep_()))}disableAnimationsForTesting(){this.animationsEnabled_=false}onConsentStepResolved_(){const savingDurationMs=this.animationsEnabled_?1500:0;this.navigateToStep_(PrivacySandboxCombinedDialogStep.SAVING).then((()=>new Promise((r=>setTimeout(r,savingDurationMs))))).then((()=>this.navigateToStep_(PrivacySandboxCombinedDialogStep.NOTICE))).then((()=>this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_SHOWN))).then((()=>this.updateScrollableContentsCurrentStep_()))}navigateToStep_(step){assert(step!==this.step_);this.step_=step;const enterAnimation=this.animationsEnabled_?"fade-in":"no-animation";const exitAnimation=this.animationsEnabled_?"fade-out":"no-animation";return this.$.viewManager.switchView(this.step_,enterAnimation,exitAnimation)}promptActionOccurred(action){PrivacySandboxDialogBrowserProxy.getInstance().promptActionOccurred(action)}updateScrollableContentsCurrentStep_(){const stepElement=this.getStepElement_(this.step_);stepElement.updateScrollableContents();return stepElement.maybeShowMoreButton()}getStepElement_(step){return this.shadowRoot.querySelector(`#${step}`)}}customElements.define(PrivacySandboxCombinedDialogAppElement.is,PrivacySandboxCombinedDialogAppElement);