import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  :host {
    display: flex;
    width: 100%;
    height: 100%;
    --cr-font-family: 'Roboto', sans-serif;
    --cr-font-size-sm: 13px;
    --tabs-background-color: #ffffff;
    --tabs-border-color: #e0e0e0;
    --tabs-hover-text-color: #202124;
    --tabs-unselected-text-color: #5f6368;
    --cr-primary-text-color: #202124;
    --cr-active-text-color: #1a73e8;
    --cr-active-background-color: #e8f0fe;
  }

  #sidebar-container {
    display: flex;
    flex-direction: column;
    flex-shrink: 0;
    background: var(--tabs-background-color);
    border-right: 1px solid var(--tabs-border-color);
    transition: min-width 0.2s ease-in-out;
    overflow-y: auto;
  }

  :host([collapsed]) #sidebar-container {
    border-right-color: transparent;
  }

  #sidebar-visibility-button {
    background: none;
    border: none;
    cursor: pointer;
    padding: 8px;
    margin: 8px;
    align-self: flex-start;
    flex-shrink: 0;
  }

  #sidebar-visibility-button svg {
    display: block;
    width: 32px;
    height: 32px;
    fill: var(--cr-primary-text-color);
  }

  #tablist {
    display: flex;
    flex-direction: column;
    min-width: 250px;
    font-family: var(--cr-font-family);
    font-size: var(--cr-font-size-sm);
    padding: 8px 0;
  }

  :host([collapsed]) #tablist {
    display: none;
  }

  #tablist ::slotted(.settings-category-header)::before,
  #tablist ::slotted(.setting-header)::before {
    content: '';
    display: inline-block;
    flex-shrink: 0;
    width: 24px;
    height: 24px;
    margin-right: 8px;
    background-color: var(--tabs-unselected-text-color);
    mask-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M10 17l5-5-5-5v10z"></path></svg>');
    mask-size: contain;
    mask-repeat: no-repeat;
    mask-position: center;
  }

  #tablist ::slotted(.settings-category-header:not([collapsed]))::before,
  #tablist ::slotted(.setting-header:not([collapsed]))::before {
    mask-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M7 10l5 5 5-5H7z"></path></svg>');
  }

  #tablist ::slotted(.settings-category-header) {
    cursor: pointer;
    display: flex;
    align-items: center;
    font-weight: 900;
    text-transform: uppercase;
    color: var(--cr-primary-text-color);
    padding: 16px 24px 8px;
  }

  #tablist ::slotted(.setting-header) {
    cursor: pointer;
    display: flex;
    align-items: center;
    font-weight: 700;
    color: var(--cr-primary-text-color);
    padding: 12px 24px 4px 32px;
  }

  #tablist ::slotted(:not([role='heading'])) {
    padding: 0 24px 0 56px;
    height: 32px;
    display: flex;
    align-items: center;
    border-inline-start: 4px solid transparent;
  }

  #tablist ::slotted(:not([selected])) {
    color: var(--tabs-unselected-text-color);
  }

  #tablist ::slotted(:not([selected]):not([role='heading']):hover) {
    color: var(--tabs-hover-text-color);
    background-color: #f1f3f4;
  }

  #tablist ::slotted([selected]) {
    font-weight: bold;
    color: var(--cr-active-text-color);
    background-color: var(--cr-active-background-color);
    border-inline-start-color: var(--cr-active-text-color);
  }

  #tablist ::slotted(.hidden-by-group) {
    display: none;
  }

  #tablist:focus {
    outline: none;
  }

  #tabpanels {
    box-shadow: none;
    display: inline-block;
    flex-grow: 1;
    overflow: auto;
    vertical-align: top;
    padding: 4px 9px 4px 10px;
  }

  #tabpanels ::slotted(*) {
    display: none;
  }

  #tabpanels ::slotted([selected]) {
    display: block;
    padding: 12px 24px;
  }
</style>
<div id="sidebar-container">
  <button id="sidebar-visibility-button" aria-label="Toggle Sidebar Visibility">
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
      <path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"></path>
    </svg>
  </button>
  <span id="tablist" role="tablist">
    <slot name="tab"></slot>
  </span>
</div>
<span id="tabpanels">
  <slot name="panel"></slot>
</span><!--_html_template_end_-->`;
}
