export declare enum ItemsToRender {
    ISSUER_LIST = "list",
    ISSUER_METADATA = "metadata"
}
interface Metadata {
    issuerOrigin: string;
    expiration: string;
    purposes: string[];
}
interface ListItem {
    issuerOrigin: string;
    numTokens: number;
    redemptions: Redemption[];
    metadata: Metadata;
}
interface Redemption {
    origin: string;
    formattedTimestamp: string;
}
export declare const nullMetadataObj: Metadata;
export type { ListItem, Metadata, Redemption };
