import type { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { Setting, Settings } from '../data/model.js';
import type { ChangeCallback } from '../data/observable.js';
type Constructor<T> = new (...args: any[]) => T;
export declare const SettingsMixin: <T extends Constructor<CrLitElement>>(superClass: T) => T & Constructor<SettingsMixinInterface>;
export interface SettingsMixinInterface {
    addSettingObserver(path: string, callback: ChangeCallback): void;
    /**
     * @param settingName Name of the setting to get.
     * @return The setting object.
     */
    getSetting(settingName: keyof Settings): Setting;
    /**
     * @param settingName Name of the setting to get the value for.
     * @return The value of the setting, accounting for availability.
     */
    getSettingValue(settingName: keyof Settings): any;
    /**
     * Sets settings.settingName.value to |value|, unless updating the setting is
     * disallowed by enterprise policy. Fires preview-setting-changed and
     * sticky-setting-changed events if the update impacts the preview or requires
     * an update to sticky settings.
     * @param settingName Name of the setting to set
     * @param value The value to set the setting to.
     * @param noSticky Whether to avoid stickying the setting. Defaults to false.
     */
    setSetting(settingName: keyof Settings, value: any, noSticky?: boolean): void;
    /**
     * Sets the validity of |settingName| to |valid|. If the validity is changed,
     * fires a setting-valid-changed event.
     * @param settingName Name of the setting to set
     * @param valid Whether the setting value is currently valid.
     */
    setSettingValid(settingName: keyof Settings, valid: boolean): void;
}
export {};
