// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { html } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    // clang-format off
    return html `<!--_html_template_start_-->

  <cr-button class="cancel-button" @click="${this.onCancelClick_}">
    $i18n{cancel}
  </cr-button>

  <cr-button class="action-button" @click="${this.onPrintClick_}"
      ?disabled="${!this.printButtonEnabled_}">
    ${this.printButtonLabel_}
  </cr-button>

<!--_html_template_end_-->`;
    // clang-format on
}
