import {html} from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type {ViewerToolbarElement} from './viewer_toolbar.js';

import {AnnotationMode} from '../constants.js';


export function getHtml(this: ViewerToolbarElement) {
  return html`<!--_html_template_start_--><!-- #html_wrapper_imports_start

import {AnnotationMode} from '../constants.js';

#html_wrapper_imports_end -->

<div id="toolbar">
  <div id="start">
    <cr-icon-button id="sidenavToggle" iron-icon="pdf:menu"
        title="$i18n{sidebarLabel}" aria-label="$i18n{sidebarLabel}"
        aria-expanded="${this.getAriaExpanded_()}"
        @click="${this.onSidenavToggleClick_}">
    </cr-icon-button>
    <span id="title">${this.docTitle}</span>
  </div>
  <div id="center">
    <viewer-page-selector .docLength="${this.docLength}"
        .pageNo="${this.pageNo}">
    </viewer-page-selector>
    <span class="vertical-separator"></span>
    <span id="zoom-controls">
      <cr-icon-button
          iron-icon="pdf:remove"
          title="$i18n{tooltipZoomOut}"
          ?disabled="${this.isAtMinimumZoom_()}"
          aria-label="$i18n{tooltipZoomOut}" @click="${this.onZoomOutClick_}">
      </cr-icon-button>
      <input type="text" value="100%"
          aria-label="$i18n{zoomTextInputAriaLabel}"
          @change="${this.onZoomChange_}"
          @pointerup="${this.onZoomInputPointerup_}"
          @blur="${this.onZoomChange_}">
      </input>
      <cr-icon-button
          iron-icon="pdf:add"
          title="$i18n{tooltipZoomIn}"
          ?disabled="${this.isAtMaximumZoom_()}"
          aria-label="$i18n{tooltipZoomIn}" @click="${this.onZoomInClick_}">
      </cr-icon-button>
    </span>
    <span class="vertical-separator"></span>
    <cr-icon-button id="fit" .ironIcon="${this.fitToButtonIcon_()}"
        title="${this.getFitToButtonTooltip_()}"
        aria-label="${this.getFitToButtonTooltip_()}"
        @click="${this.onFitToButtonClick_}">
    </cr-icon-button>
    <cr-icon-button id="rotate" iron-icon="pdf:rotate-left"
        suppress-rtl-flip
        aria-label="$i18n{tooltipRotateCCW}" title="$i18n{tooltipRotateCCW}"
        @click="${this.onRotateClick_}">
    </cr-icon-button>

    ${this.showInk2Buttons_() ? html`
      <span id="annotate-controls">
        <span class="vertical-separator"></span>
        ${this.pdfTextAnnotationsEnabled_ ? html`
          <cr-icon-button id="text-annotate" iron-icon="pdf-ink:text-annotate"
              class="annotate-button ${this.getActive_(AnnotationMode.TEXT)}"
              @click="${this.onTextAnnotationClick_}"
              ?disabled="${!this.annotationAvailable}"
              aria-pressed="${this.getAriaPressed_(AnnotationMode.TEXT)}"
              aria-label="$i18n{ink2TextAnnotation}"
              title="$i18n{ink2TextAnnotation}">
          </cr-icon-button>
        ` : ''}
        <cr-icon-button id="annotate" iron-icon="pdf-ink:annotate"
            class="annotate-button ${this.getActive_(AnnotationMode.DRAW)}"
            @click="${this.onAnnotationClick_}"
            ?disabled="${!this.annotationAvailable}"
            aria-pressed="${this.getAriaPressed_(AnnotationMode.DRAW)}"
            aria-label="$i18n{ink2Draw}"
            title="$i18n{ink2Draw}"></cr-icon-button>
        <span class="vertical-separator"></span>
        <cr-icon-button id="undo" ?disabled="${!this.computeEnableUndo_()}"
            iron-icon="pdf:undo"
            @click="${this.undo}"
            aria-label="$i18n{annotationUndo}"
            title="$i18n{annotationUndo}"></cr-icon-button>
        <cr-icon-button id="redo" ?disabled="${!this.computeEnableRedo_()}"
            iron-icon="pdf:redo"
            @click="${this.redo}"
            aria-label="$i18n{annotationRedo}"
            title="$i18n{annotationRedo}"></cr-icon-button>
      </span>` : ''}

  </div>
  <div id="end">

    ${this.pdfSaveToDriveEnabled ? html`
    <viewer-save-to-drive-controls id="save-to-drive"
        .hasEdits="${this.hasEdits}"
        .hasEnteredAnnotationMode="${this.hasEnteredAnnotationMode}"

        .hasInk2Edits="${this.hasInk2Edits}"

        .isFormFieldFocused="${this.isFormFieldFocused_()}"
        .progress="${this.saveToDriveProgress}"
        .state="${this.saveToDriveState}">
    </viewer-save-to-drive-controls>` : ''}

    <viewer-download-controls id="downloads"
        .hasEdits="${this.hasEdits}"
        .hasEnteredAnnotationMode="${this.hasEnteredAnnotationMode}"

        .hasInk2Edits="${this.hasInk2Edits}"

        .isFormFieldFocused="${this.isFormFieldFocused_()}">
    </viewer-download-controls>
    <cr-icon-button id="print" iron-icon="pdf:print"
        ?hidden="${!this.printingEnabled_}" title="$i18n{tooltipPrint}"
        aria-label="$i18n{tooltipPrint}" @click="${this.onPrintClick_}">
    </cr-icon-button>
    <cr-icon-button id="more" iron-icon="pdf:more"
        title="$i18n{moreActions}" aria-label="$i18n{moreActions}"
        @click="${this.onMoreClick_}"></cr-icon-button>
  </div>
</div>
<cr-progress id="progress" .value="${this.loadProgress}"
    ?hidden="${!this.loading_}">
</cr-progress>

<cr-action-menu id="menu" @open-changed="${this.onMoreOpenChanged_}">
  <button id="two-page-view-button" class="dropdown-item"
      @click="${this.toggleTwoPageViewClick_}" role="checkbox"
      aria-checked="${this.getAriaChecked_(this.twoUpViewEnabled)}">
    <span class="check-container">
      <cr-icon icon="pdf:check"
          ?hidden="${!this.twoUpViewEnabled}"></cr-icon>
    </span>
    $i18n{twoUpViewEnable}
  </button>

  <button id="show-annotations-button"
      class="dropdown-item" @click="${this.toggleDisplayAnnotations_}"
      role="checkbox"
      aria-checked="${this.getAriaChecked_(this.displayAnnotations_)}">
    <span class="check-container">
      <cr-icon icon="pdf:check"
          ?hidden="${!this.displayAnnotations_}">
      </cr-icon>
    </span>
    $i18n{annotationsShowToggle}
  </button>

  <hr>

  <button id="present-button" class="dropdown-item"
      @click="${this.onPresentClick_}"
      ?disabled="${!this.presentationModeAvailable_()}">
    <span class="check-container" aria-hidden="true"></span>
    $i18n{present}
  </button>

  <button id="properties-button" class="dropdown-item"
      @click="${this.onPropertiesClick_}">
    <span class="check-container" aria-hidden="true"></span>
    $i18n{propertiesDialogTitle}
  </button>
</cr-action-menu>
<!--_html_template_end_-->`;
}