import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style cr-shared-style">#header{align-items:center;display:flex}a[href]{color:var(--cr-link-color)}#addPasswordButton{height:auto;padding:3px 16px}#passwords{margin-top:20px}promo-card{margin-bottom:24px;margin-top:24px}.page-title{flex:1}</style>
<template is="dom-if" if="[[shouldShowPromoCard_]]" restamp>
  <promo-card id="promoCard" class="card" promo-card="[[promoCard_]]"
      role="region" aria-label="$i18n{promoCardAriaLabel}"
      on-promo-closed="onPromoClosed_">
  </promo-card>
</template>
<div id="header">
  <h2 class="page-title">$i18n{passwords}</h2>
  <cr-button id="addPasswordButton" on-click="onAddPasswordClick_"
      title="$i18n{addPasswordTitle}" hidden="[[passwordManagerDisabled_]]">
    $i18n{addPassword}
  </cr-button>
</div>
<div id="descriptionLabel" class="cr-secondary-text"
    hidden="[[!showPasswordsDescription_]]"
    inner-h-t-m-l="[[i18nAdvanced('passwordsSectionDescription')]]">
</div>
<div id="importPasswords" class="cr-secondary-text"
    hidden="[[!showImportPasswordsOption_(groups_, passwordManagerDisabled_)]]"
    inner-h-t-m-l="[[importPasswordsText_]]">
</div>
<div id="noPasswordsFound" class="cr-secondary-text"
    hidden="[[!showNoPasswordsFound_(groups_, searchTerm_)]]">
  $i18n{noPasswordsFound}
</div>
<div class="card" id="passwords" role="list"
    hidden$="[[hideGroupsList_(groups_, searchTerm_)]]"
    aria-label="$i18n{passwordListAriaLabel}">
  <template id="passwordsList" is="dom-repeat" initial-count="50"
      items="[[groups_]]" filter="[[groupFilter_(searchTerm_)]]"
      rendered-item-count="{{shownGroupsCount_::dom-change}}"
      sort="[[computeSortFunction_(searchTerm_)]]">
    <password-list-item item="[[item]]" first="[[!index]]"
        is-account-store-user="[[isAccountStoreUser]]"
        on-password-details-shown="onPasswordDetailsShown_"
        search-term="[[searchTerm_]]" role="listitem">
    </password-list-item>
  </template>
</div>
<template is="dom-if" if="[[showAddPasswordDialog_]]" restamp>
  <add-password-dialog on-close="onAddPasswordDialogClose_"
      id="addPasswordDialog">
  </add-password-dialog>
</template>
<template is="dom-if" if="[[showAuthTimedOutDialog_]]" restamp>
  <auth-timed-out-dialog on-close="onAuthTimedOutDialogClose_"
      id="authTimedOutDialog">
  </auth-timed-out-dialog>
</template>
<!--_html_template_end_-->`;
}
