// chrome/browser/ui/webui/password_manager/password_manager.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'password_manager.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "password_manager.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'password_manager.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    extendAuthValidity() {
        this.proxy.sendMessage(0, PageHandler_ExtendAuthValidity_ParamsSpec.$, null, [], false);
    }
    deleteAllPasswordManagerData() {
        return this.proxy.sendMessage(1, PageHandler_DeleteAllPasswordManagerData_ParamsSpec.$, PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec.$, [], false);
    }
    copyPlaintextBackupPassword(id) {
        return this.proxy.sendMessage(2, PageHandler_CopyPlaintextBackupPassword_ParamsSpec.$, PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec.$, [
            id
        ], false);
    }
    removeBackupPassword(id) {
        this.proxy.sendMessage(3, PageHandler_RemoveBackupPassword_ParamsSpec.$, null, [
            id
        ], false);
    }
    getActorLoginPermissions() {
        return this.proxy.sendMessage(4, PageHandler_GetActorLoginPermissions_ParamsSpec.$, PageHandler_GetActorLoginPermissions_ResponseParamsSpec.$, [], false);
    }
    revokeActorLoginPermission(site) {
        this.proxy.sendMessage(5, PageHandler_RevokeActorLoginPermission_ParamsSpec.$, null, [
            site
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_ExtendAuthValidity_ParamsSpec.$, null, impl.extendAuthValidity.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_DeleteAllPasswordManagerData_ParamsSpec.$, PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec.$, impl.deleteAllPasswordManagerData.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_CopyPlaintextBackupPassword_ParamsSpec.$, PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec.$, impl.copyPlaintextBackupPassword.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_RemoveBackupPassword_ParamsSpec.$, null, impl.removeBackupPassword.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_GetActorLoginPermissions_ParamsSpec.$, PageHandler_GetActorLoginPermissions_ResponseParamsSpec.$, impl.getActorLoginPermissions.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_RevokeActorLoginPermission_ParamsSpec.$, null, impl.revokeActorLoginPermission.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "password_manager.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    extendAuthValidity;
    deleteAllPasswordManagerData;
    copyPlaintextBackupPassword;
    removeBackupPassword;
    getActorLoginPermissions;
    revokeActorLoginPermission;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.extendAuthValidity =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_ExtendAuthValidity_ParamsSpec.$, null, this.extendAuthValidity.createReceiverHandler(false /* expectsResponse */), false);
        this.deleteAllPasswordManagerData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_DeleteAllPasswordManagerData_ParamsSpec.$, PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec.$, this.deleteAllPasswordManagerData.createReceiverHandler(true /* expectsResponse */), false);
        this.copyPlaintextBackupPassword =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_CopyPlaintextBackupPassword_ParamsSpec.$, PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec.$, this.copyPlaintextBackupPassword.createReceiverHandler(true /* expectsResponse */), false);
        this.removeBackupPassword =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_RemoveBackupPassword_ParamsSpec.$, null, this.removeBackupPassword.createReceiverHandler(false /* expectsResponse */), false);
        this.getActorLoginPermissions =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_GetActorLoginPermissions_ParamsSpec.$, PageHandler_GetActorLoginPermissions_ResponseParamsSpec.$, this.getActorLoginPermissions.createReceiverHandler(true /* expectsResponse */), false);
        this.revokeActorLoginPermission =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_RevokeActorLoginPermission_ParamsSpec.$, null, this.revokeActorLoginPermission.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'password_manager.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(_impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "password_manager.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const FormattedUrlSpec = { $: {} };
export const ActorLoginPermissionSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_ExtendAuthValidity_ParamsSpec = { $: {} };
export const PageHandler_DeleteAllPasswordManagerData_ParamsSpec = { $: {} };
export const PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec = { $: {} };
export const PageHandler_CopyPlaintextBackupPassword_ParamsSpec = { $: {} };
export const PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec = { $: {} };
export const PageHandler_RemoveBackupPassword_ParamsSpec = { $: {} };
export const PageHandler_GetActorLoginPermissions_ParamsSpec = { $: {} };
export const PageHandler_GetActorLoginPermissions_ResponseParamsSpec = { $: {} };
export const PageHandler_RevokeActorLoginPermission_ParamsSpec = { $: {} };
mojo.internal.Struct(FormattedUrlSpec.$, 'FormattedUrl', [
    mojo.internal.StructField('humanReadableUrl', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('link', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ActorLoginPermissionSpec.$, 'ActorLoginPermission', [
    mojo.internal.StructField('url', 0, 0, FormattedUrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('username', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ExtendAuthValidity_ParamsSpec.$, 'PageHandler_ExtendAuthValidity_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_DeleteAllPasswordManagerData_ParamsSpec.$, 'PageHandler_DeleteAllPasswordManagerData_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec.$, 'PageHandler_DeleteAllPasswordManagerData_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_CopyPlaintextBackupPassword_ParamsSpec.$, 'PageHandler_CopyPlaintextBackupPassword_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec.$, 'PageHandler_CopyPlaintextBackupPassword_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RemoveBackupPassword_ParamsSpec.$, 'PageHandler_RemoveBackupPassword_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetActorLoginPermissions_ParamsSpec.$, 'PageHandler_GetActorLoginPermissions_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetActorLoginPermissions_ResponseParamsSpec.$, 'PageHandler_GetActorLoginPermissions_ResponseParams', [
    mojo.internal.StructField('sites', 0, 0, mojo.internal.Array(ActorLoginPermissionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RevokeActorLoginPermission_ParamsSpec.$, 'PageHandler_RevokeActorLoginPermission_Params', [
    mojo.internal.StructField('site', 0, 0, ActorLoginPermissionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
