import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style cr-shared-style">cr-input:not(:first-of-type){margin-top:var(--cr-form-field-bottom-spacing)}cr-icon-button{--cr-icon-button-icon-size:16px;--cr-icon-button-size:32px;--cr-icon-button-margin-start:0;--cr-icon-button-margin-end:0}cr-input{--cr-input-error-display:none}cr-textarea{--cr-textarea-footer-display:flex;--cr-textarea-autogrow-max-height:20lh}#usernameInput[invalid]{--cr-input-error-display:block}#usernameInput,#passwordNote{margin-top:var(--cr-form-field-bottom-spacing)}#viewExistingPasswordLink{color:var(--cr-link-color);display:block;font-size:var(--cr-form-field-label-font-size);line-height:1;width:fit-content}#footnote{margin-inline-start:2px;margin-top:16px}</style>
<cr-dialog id="dialog" show-on-attach>
  <div slot="title" id="title" class="dialog-title">
    $i18n{editPasswordTitle}
  </div>
  <div slot="body">
    <div class="cr-form-field-label">$i18n{sitesLabel}</div>
    <template id="links" is="dom-repeat"
        items="[[credential.affiliatedDomains]]">
      <div class="elide-left">
        <a href="[[item.url]]" class="site-link" target="_blank">
          [[item.name]]
        </a>
      </div>
    </template>
    <cr-input id="usernameInput" label="$i18n{usernameLabel}" autofocus
        value="{{username_}}" error-message="[[usernameErrorMessage_]]"
        invalid="[[doesUsernameExistAlready_(usernameErrorMessage_)]]"
        spellcheck="false">
    </cr-input>
    <a id="viewExistingPasswordLink" is="action-link" href="/"
        on-click="onViewExistingPasswordClick_"
        aria-description="[[getViewExistingPasswordAriaDescription_(
          conflictingUsernames_, username_)]]"
        hidden="[[!showRedirect_(showRedirect, usernameErrorMessage_)]]">
      $i18n{viewExistingPassword}
    </a>
    <cr-input id="passwordInput" label="$i18n{passwordLabel}" required
        type="[[getPasswordInputType(isPasswordVisible)]]"
        value="{{password_}}" invalid="[[!password_.length]]"
        class="password-input" spellcheck="false">
      <cr-icon-button id="showPasswordButton" slot="inline-suffix"
          class$="[[getShowHideButtonIconClass(isPasswordVisible)]]"
          title="[[getShowHideButtonLabel(isPasswordVisible)]]"
          on-click="onShowHidePasswordButtonClick">
      </cr-icon-button>
    </cr-input>
    <div id="footnote">
      [[getFootnote_(credential)]]
    </div>
    <cr-textarea id="passwordNote" label="$i18n{noteLabel}" value="{{note_}}"
        invalid="[[isNoteInputInvalid_(note_)]]" has-max-height autogrow
        first-footer="[[getFirstNoteFooter_(note_)]]"
        second-footer="[[getSecondNoteFooter_(note_)]]">
    </cr-textarea>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button" on-click="onCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="saveButton" class="action-button"
        disabled="[[!canEditPassword_]]" on-click="onEditClick_">
      $i18n{save}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
