import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-actionable-row-style cr-shared-style shared-style">:host{--cr-icon-button-margin-end:20px;padding:0 var(--cr-section-padding)}#outerRow{align-items:center;display:flex;min-height:var(--two-line-section-min-height);width:100%}#outerRow[noSubLabel]{min-height:var(--section-min-height)}#labelWrapper{flex:1;margin-inline-end:var(--control-label-spacing);padding:var(--cr-section-vertical-padding) 0}cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}</style>
<div id="outerRow" noSubLabel$="[[!subLabel]]">
  <div id="labelWrapper">
    <div class="label" aria-hidden="true">[[label]]</div>
    <div class="cr-secondary-text label" id="sub-label" hidden="[[!subLabel]]">
      <span id="sub-label-text" aria-hidden="true">
        [[subLabel]]
      </span>
    </div>
  </div>
  <template is="dom-if" if="[[hasPrefPolicyIndicator_(pref.*)]]">
    <cr-policy-pref-indicator pref="[[pref]]" icon-aria-label="[[label]]">
    </cr-policy-pref-indicator>
  </template>
  <cr-toggle id="control" checked="{{checked}}"
      disabled="[[controlDisabled_(pref.*, disabled)]]"
      on-change="onToggleClick_"
      aria-label="[[getAriaLabel_(label, subLabel)]]">
  </cr-toggle>
</div>
<!--_html_template_end_-->`;
}