import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style cr-shared-style">:host{display:flex;flex-direction:column}site-favicon{padding-inline-end:20px}#list-item{align-items:center;display:flex;padding:16px 20px}#credentialInfo{display:grid;flex:2}#insecurePassword{background-color:transparent;border:none;color:var(--cr-secondary-text-color);font-size:inherit;margin-bottom:2px;margin-inline-start:4px;max-width:10ch}#usernameContainer{display:flex}#username{max-width:200px}#changeButton{align-items:flex-end;display:flex;flex-direction:column;margin-inline-start:var(--cr-icon-button-margin-start)}#change-password-link-icon{--iron-icon-width:16px;margin-inline-start:10px}#separator{margin-inline-start:56px}#alreadyChanged{color:var(--cr-link-color);flex:1;margin-top:8px;text-align:end}#changePasswordButton{height:auto;padding:3px 16px}</style>
<div id="separator" class="hr" hidden="[[first]]"></div>
<div id="list-item" focus-row-container>
  <site-favicon url="[[getGroupIcon_(group, item)]]" 
      domain="[[getGroupName_(group, item)]]" aria-hidden="true">
  </site-favicon>
  <div id="credentialInfo">
    <div id="shownUrl" class="label text-elide">
      [[getGroupName_(group, item)]]
    </div>
    <div id="usernameContainer" class="cr-secondary-text label">
      <span id="username" class="text-elide">[[item.username]]</span>
      <input id="insecurePassword" focus-row-control class="password-input"
          focus-type="passwordField" readonly disabled
          type="[[getPasswordInputType(isPasswordVisible)]]"
          value="[[getPasswordValue_(item, isPasswordVisible)]]">
    </div>
    <template is="dom-if" if="[[showDetails]]">
      <div class="cr-secondary-text label text-elide" id="compromiseType">
        [[getCompromiseDescription_(item)]]
      </div>
      <div class="cr-secondary-text label text-elide" id="elapsedTime">
        [[item.compromisedInfo.elapsedTimeSinceCompromise]]
      </div>
    </template>
  </div>
  <template is="dom-if" if="[[item.changePasswordUrl]]">
    <div class="button-container" id="changeButton">
      <cr-button id="changePasswordButton" on-click="onChangePasswordClick_"
          aria-label$="[[getChangeButtonAriaLabel_(group, item)]]">
        $i18n{changePassword}
        <cr-icon icon="cr:open-in-new" id="change-password-link-icon">
        </cr-icon>
      </cr-button>
      <a id="alreadyChanged" hidden="[[!showAlreadyChanged]]" href="/"
          on-click="onAlreadyChangedClick_">
        $i18n{alreadyChangedPasswordLink}
      </a>
    </div>
  </template>
  <template is="dom-if" if="[[!item.changePasswordUrl]]">
    <span id="changePasswordInApp">$i18n{changePasswordInApp}</span>
  </template>
  <cr-icon-button class="icon-more-vert" id="more" title="$i18n{moreActions}"
      on-click="onMoreClick_" 
      aria-label$="[[getMoreButtonAriaLabel_(group, item)]]">
  </cr-icon-button>
</div>
<template is="dom-if" if="[[showEditPasswordDisclaimer_]]" restamp>
  <edit-password-disclaimer-dialog
      on-edit-password-click="onEditPasswordClick_"
      origin="[[getGroupName_(group)]]"
      on-close="onEditDisclaimerClosed_">
  </edit-password-disclaimer-dialog>
</template>
<template is="dom-if" if="[[showEditPasswordDialog_]]" restamp>
  <edit-password-dialog on-close="onEditPasswordDialogClosed_"
      id="editPasswordDialog" credential="[[item]]" show-redirect>
  </edit-password-dialog>
</template>
<template is="dom-if" if="[[showDeletePasswordDialog_]]" restamp>
  <delete-password-disclaimer-dialog id="deletePasswordDialog"
      on-delete-password-click="onDeletePasswordClick_"
      on-close="onDeletePasswordDialogClosed_" origin="[[getGroupName_(group)]]"
      action-url="[[item.changePasswordUrl]]">
  </delete-password-disclaimer-dialog>
</template>
<!--_html_template_end_-->`;
}