// services/on_device_model/public/mojom/on_device_model.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  FileSpec as mojoBase_mojom_FileSpec,
  File as mojoBase_mojom_File
} from '//resources/mojo/mojo/public/mojom/base/file.mojom-webui.js';
import {
  FilePathSpec as mojoBase_mojom_FilePathSpec,
  FilePath as mojoBase_mojom_FilePath
} from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import {
  BitmapWithArbitraryBppSpec as skia_mojom_BitmapWithArbitraryBppSpec,
  BitmapWithArbitraryBpp as skia_mojom_BitmapWithArbitraryBpp
} from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';





export const TokenSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum Token {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kSystem = 0,
  kModel = 1,
  kUser = 2,
  kEnd = 3,
}

export const PrioritySpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum Priority {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kForeground = 0,
  kBackground = 1,
}

export const PerformanceClassSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum PerformanceClass {

  MIN_VALUE = 0,
  MAX_VALUE = 7,
  kError = 0,
  kGpuBlocked = 1,
  kFailedToLoadLibrary = 2,
  kVeryLow = 3,
  kLow = 4,
  kMedium = 5,
  kHigh = 6,
  kVeryHigh = 7,
}

export const LoadModelResultSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum LoadModelResult {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kSuccess = 0,
  kGpuBlocked = 1,
  kFailedToLoadLibrary = 2,
}



export type StreamingResponderPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<StreamingResponderPendingReceiver>;

export class StreamingResponderPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<StreamingResponder> {

  handle: mojo.internal.interfaceSupport.Endpoint<StreamingResponderPendingReceiver>;
  constructor(handle: MojoHandle|StreamingResponderPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.StreamingResponder',
        scope);
  }
}

export interface StreamingResponderInterface {
  onResponse(chunk: ResponseChunk): void;
  onComplete(summary: ResponseSummary): void;
}

export class StreamingResponderRemote implements StreamingResponderInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<StreamingResponderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<StreamingResponderPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|StreamingResponderPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          StreamingResponderPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onResponse(
      chunk: ResponseChunk): void {
    this.proxy.sendMessage(
        0,
        StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        [
          chunk
        ],
        false);
  }

  onComplete(
      summary: ResponseSummary): void {
    this.proxy.sendMessage(
        1,
        StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        [
          summary
        ],
        false);
  }
};

/**
 * An object which receives request messages for the StreamingResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StreamingResponderReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    StreamingResponderRemote, StreamingResponderPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    StreamingResponderRemote, StreamingResponderPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: StreamingResponderInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        StreamingResponderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        impl.onResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class StreamingResponder {
  static get $interfaceName(): string {
    return "on_device_model.mojom.StreamingResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): StreamingResponderRemote {
    let remote = new StreamingResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the StreamingResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StreamingResponderCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    StreamingResponderRemote, StreamingResponderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    StreamingResponderRemote, StreamingResponderPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onResponse: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      StreamingResponderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        this.onResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ContextClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ContextClientPendingReceiver>;

export class ContextClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ContextClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<ContextClientPendingReceiver>;
  constructor(handle: MojoHandle|ContextClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.ContextClient',
        scope);
  }
}

export interface ContextClientInterface {
  onComplete(tokensProcessed: number): void;
}

export class ContextClientRemote implements ContextClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ContextClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ContextClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ContextClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ContextClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onComplete(
      tokensProcessed: number): void {
    this.proxy.sendMessage(
        0,
        ContextClient_OnComplete_ParamsSpec.$,
        null,
        [
          tokensProcessed
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ContextClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContextClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ContextClientRemote, ContextClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ContextClientRemote, ContextClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ContextClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ContextClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ContextClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ContextClient {
  static get $interfaceName(): string {
    return "on_device_model.mojom.ContextClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ContextClientRemote {
    let remote = new ContextClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ContextClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContextClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ContextClientRemote, ContextClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ContextClientRemote, ContextClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ContextClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ContextClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type SessionPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<SessionPendingReceiver>;

export class SessionPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Session> {

  handle: mojo.internal.interfaceSupport.Endpoint<SessionPendingReceiver>;
  constructor(handle: MojoHandle|SessionPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.Session',
        scope);
  }
}

export interface SessionInterface {
  append(options: AppendOptions, client: (ContextClientRemote | null)): void;
  generate(options: GenerateOptions, responder: StreamingResponderRemote): void;
  getSizeInTokens(input: Input): Promise<{
        size: number, }>;
  score(text: string): Promise<{
        probability: number, }>;
  clone(session: SessionPendingReceiver): void;
  getProbabilitiesBlocking(text: string): Promise<{
        probabilities: number[], }>;
  setPriority(priority: Priority): void;
  asrStream(options: AsrStreamOptions, stream: AsrStreamInputPendingReceiver, responder: AsrStreamResponderRemote): void;
}

export class SessionRemote implements SessionInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<SessionPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<SessionPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|SessionPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SessionPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  append(
      options: AppendOptions,
      client: (ContextClientRemote | null)): void {
    this.proxy.sendMessage(
        6,
        Session_Append_ParamsSpec.$,
        null,
        [
          options,
          client
        ],
        false);
  }

  generate(
      options: GenerateOptions,
      responder: StreamingResponderRemote): void {
    this.proxy.sendMessage(
        7,
        Session_Generate_ParamsSpec.$,
        null,
        [
          options,
          responder
        ],
        false);
  }

  getSizeInTokens(
      input: Input): Promise<{
        size: number, }> {
    return this.proxy.sendMessage(
        5,
        Session_GetSizeInTokens_ParamsSpec.$,
        Session_GetSizeInTokens_ResponseParamsSpec.$,
        [
          input
        ],
        false);
  }

  score(
      text: string): Promise<{
        probability: number, }> {
    return this.proxy.sendMessage(
        3,
        Session_Score_ParamsSpec.$,
        Session_Score_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  clone(
      session: SessionPendingReceiver): void {
    this.proxy.sendMessage(
        4,
        Session_Clone_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }

  getProbabilitiesBlocking(
      text: string): Promise<{
        probabilities: number[], }> {
    return this.proxy.sendMessage(
        8,
        Session_GetProbabilitiesBlocking_ParamsSpec.$,
        Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  setPriority(
      priority: Priority): void {
    this.proxy.sendMessage(
        9,
        Session_SetPriority_ParamsSpec.$,
        null,
        [
          priority
        ],
        false);
  }

  asrStream(
      options: AsrStreamOptions,
      stream: AsrStreamInputPendingReceiver,
      responder: AsrStreamResponderRemote): void {
    this.proxy.sendMessage(
        10,
        Session_AsrStream_ParamsSpec.$,
        null,
        [
          options,
          stream,
          responder
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Session
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SessionReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    SessionRemote, SessionPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    SessionRemote, SessionPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: SessionInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SessionRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        6,
        Session_Append_ParamsSpec.$,
        null,
        impl.append.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Session_Generate_ParamsSpec.$,
        null,
        impl.generate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Session_GetSizeInTokens_ParamsSpec.$,
        Session_GetSizeInTokens_ResponseParamsSpec.$,
        impl.getSizeInTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Session_Score_ParamsSpec.$,
        Session_Score_ResponseParamsSpec.$,
        impl.score.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Session_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Session_GetProbabilitiesBlocking_ParamsSpec.$,
        Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        impl.getProbabilitiesBlocking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        Session_SetPriority_ParamsSpec.$,
        null,
        impl.setPriority.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        Session_AsrStream_ParamsSpec.$,
        null,
        impl.asrStream.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Session {
  static get $interfaceName(): string {
    return "on_device_model.mojom.Session";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): SessionRemote {
    let remote = new SessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Session
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SessionCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    SessionRemote, SessionPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    SessionRemote, SessionPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  append: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  generate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSizeInTokens: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  score: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clone: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProbabilitiesBlocking: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPriority: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  asrStream: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SessionRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.append =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Session_Append_ParamsSpec.$,
        null,
        this.append.createReceiverHandler(false /* expectsResponse */),
        false);
    this.generate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Session_Generate_ParamsSpec.$,
        null,
        this.generate.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getSizeInTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Session_GetSizeInTokens_ParamsSpec.$,
        Session_GetSizeInTokens_ResponseParamsSpec.$,
        this.getSizeInTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    this.score =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Session_Score_ParamsSpec.$,
        Session_Score_ResponseParamsSpec.$,
        this.score.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Session_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getProbabilitiesBlocking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Session_GetProbabilitiesBlocking_ParamsSpec.$,
        Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        this.getProbabilitiesBlocking.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setPriority =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        Session_SetPriority_ParamsSpec.$,
        null,
        this.setPriority.createReceiverHandler(false /* expectsResponse */),
        false);
    this.asrStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        Session_AsrStream_ParamsSpec.$,
        null,
        this.asrStream.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type OnDeviceModelPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<OnDeviceModelPendingReceiver>;

export class OnDeviceModelPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<OnDeviceModel> {

  handle: mojo.internal.interfaceSupport.Endpoint<OnDeviceModelPendingReceiver>;
  constructor(handle: MojoHandle|OnDeviceModelPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.OnDeviceModel',
        scope);
  }
}

export interface OnDeviceModelInterface {
  startSession(session: SessionPendingReceiver, params: (SessionParams | null)): void;
  classifyTextSafety(text: string): Promise<{
        safetyInfo: (SafetyInfo | null), }>;
  detectLanguage(text: string): Promise<{
        result: (LanguageDetectionResult | null), }>;
  loadAdaptation(params: LoadAdaptationParams, model: OnDeviceModelPendingReceiver): Promise<{
        result: LoadModelResult, }>;
}

export class OnDeviceModelRemote implements OnDeviceModelInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<OnDeviceModelPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<OnDeviceModelPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|OnDeviceModelPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OnDeviceModelPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  startSession(
      session: SessionPendingReceiver,
      params: (SessionParams | null)): void {
    this.proxy.sendMessage(
        0,
        OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        [
          session,
          params
        ],
        false);
  }

  classifyTextSafety(
      text: string): Promise<{
        safetyInfo: (SafetyInfo | null), }> {
    return this.proxy.sendMessage(
        1,
        OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  detectLanguage(
      text: string): Promise<{
        result: (LanguageDetectionResult | null), }> {
    return this.proxy.sendMessage(
        2,
        OnDeviceModel_DetectLanguage_ParamsSpec.$,
        OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  loadAdaptation(
      params: LoadAdaptationParams,
      model: OnDeviceModelPendingReceiver): Promise<{
        result: LoadModelResult, }> {
    return this.proxy.sendMessage(
        3,
        OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        [
          params,
          model
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OnDeviceModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OnDeviceModelReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OnDeviceModelRemote, OnDeviceModelPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OnDeviceModelRemote, OnDeviceModelPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: OnDeviceModelInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OnDeviceModelRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        impl.startSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        impl.classifyTextSafety.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OnDeviceModel_DetectLanguage_ParamsSpec.$,
        OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        impl.detectLanguage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        impl.loadAdaptation.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OnDeviceModel {
  static get $interfaceName(): string {
    return "on_device_model.mojom.OnDeviceModel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): OnDeviceModelRemote {
    let remote = new OnDeviceModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the OnDeviceModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OnDeviceModelCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OnDeviceModelRemote, OnDeviceModelPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OnDeviceModelRemote, OnDeviceModelPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  startSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  classifyTextSafety: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  detectLanguage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  loadAdaptation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OnDeviceModelRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.startSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        this.startSession.createReceiverHandler(false /* expectsResponse */),
        false);
    this.classifyTextSafety =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        this.classifyTextSafety.createReceiverHandler(true /* expectsResponse */),
        false);
    this.detectLanguage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OnDeviceModel_DetectLanguage_ParamsSpec.$,
        OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        this.detectLanguage.createReceiverHandler(true /* expectsResponse */),
        false);
    this.loadAdaptation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        this.loadAdaptation.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type TextSafetySessionPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<TextSafetySessionPendingReceiver>;

export class TextSafetySessionPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<TextSafetySession> {

  handle: mojo.internal.interfaceSupport.Endpoint<TextSafetySessionPendingReceiver>;
  constructor(handle: MojoHandle|TextSafetySessionPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.TextSafetySession',
        scope);
  }
}

export interface TextSafetySessionInterface {
  classifyTextSafety(text: string): Promise<{
        safetyInfo: (SafetyInfo | null), }>;
  detectLanguage(text: string): Promise<{
        result: (LanguageDetectionResult | null), }>;
  clone(session: TextSafetySessionPendingReceiver): void;
}

export class TextSafetySessionRemote implements TextSafetySessionInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<TextSafetySessionPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<TextSafetySessionPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|TextSafetySessionPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextSafetySessionPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  classifyTextSafety(
      text: string): Promise<{
        safetyInfo: (SafetyInfo | null), }> {
    return this.proxy.sendMessage(
        1,
        TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  detectLanguage(
      text: string): Promise<{
        result: (LanguageDetectionResult | null), }> {
    return this.proxy.sendMessage(
        2,
        TextSafetySession_DetectLanguage_ParamsSpec.$,
        TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  clone(
      session: TextSafetySessionPendingReceiver): void {
    this.proxy.sendMessage(
        3,
        TextSafetySession_Clone_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextSafetySession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextSafetySessionReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TextSafetySessionRemote, TextSafetySessionPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TextSafetySessionRemote, TextSafetySessionPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: TextSafetySessionInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextSafetySessionRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        1,
        TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        impl.classifyTextSafety.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        TextSafetySession_DetectLanguage_ParamsSpec.$,
        TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        impl.detectLanguage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        TextSafetySession_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextSafetySession {
  static get $interfaceName(): string {
    return "on_device_model.mojom.TextSafetySession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): TextSafetySessionRemote {
    let remote = new TextSafetySessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the TextSafetySession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextSafetySessionCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TextSafetySessionRemote, TextSafetySessionPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TextSafetySessionRemote, TextSafetySessionPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  classifyTextSafety: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  detectLanguage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clone: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextSafetySessionRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.classifyTextSafety =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        this.classifyTextSafety.createReceiverHandler(true /* expectsResponse */),
        false);
    this.detectLanguage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TextSafetySession_DetectLanguage_ParamsSpec.$,
        TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        this.detectLanguage.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        TextSafetySession_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type TextSafetyModelPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<TextSafetyModelPendingReceiver>;

export class TextSafetyModelPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<TextSafetyModel> {

  handle: mojo.internal.interfaceSupport.Endpoint<TextSafetyModelPendingReceiver>;
  constructor(handle: MojoHandle|TextSafetyModelPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.TextSafetyModel',
        scope);
  }
}

export interface TextSafetyModelInterface {
  startSession(session: TextSafetySessionPendingReceiver): void;
}

export class TextSafetyModelRemote implements TextSafetyModelInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<TextSafetyModelPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<TextSafetyModelPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|TextSafetyModelPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextSafetyModelPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  startSession(
      session: TextSafetySessionPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextSafetyModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextSafetyModelReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TextSafetyModelRemote, TextSafetyModelPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TextSafetyModelRemote, TextSafetyModelPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: TextSafetyModelInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextSafetyModelRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        impl.startSession.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextSafetyModel {
  static get $interfaceName(): string {
    return "on_device_model.mojom.TextSafetyModel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): TextSafetyModelRemote {
    let remote = new TextSafetyModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the TextSafetyModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextSafetyModelCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TextSafetyModelRemote, TextSafetyModelPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TextSafetyModelRemote, TextSafetyModelPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  startSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextSafetyModelRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.startSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        this.startSession.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type AsrStreamResponderPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AsrStreamResponderPendingReceiver>;

export class AsrStreamResponderPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<AsrStreamResponder> {

  handle: mojo.internal.interfaceSupport.Endpoint<AsrStreamResponderPendingReceiver>;
  constructor(handle: MojoHandle|AsrStreamResponderPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.AsrStreamResponder',
        scope);
  }
}

export interface AsrStreamResponderInterface {
  onResponse(result: SpeechRecognitionResult[]): void;
}

export class AsrStreamResponderRemote implements AsrStreamResponderInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AsrStreamResponderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AsrStreamResponderPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AsrStreamResponderPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AsrStreamResponderPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onResponse(
      result: SpeechRecognitionResult[]): void {
    this.proxy.sendMessage(
        0,
        AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AsrStreamResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AsrStreamResponderReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AsrStreamResponderRemote, AsrStreamResponderPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AsrStreamResponderRemote, AsrStreamResponderPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AsrStreamResponderInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AsrStreamResponderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        impl.onResponse.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AsrStreamResponder {
  static get $interfaceName(): string {
    return "on_device_model.mojom.AsrStreamResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AsrStreamResponderRemote {
    let remote = new AsrStreamResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the AsrStreamResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AsrStreamResponderCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AsrStreamResponderRemote, AsrStreamResponderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AsrStreamResponderRemote, AsrStreamResponderPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onResponse: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AsrStreamResponderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        this.onResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type AsrStreamInputPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AsrStreamInputPendingReceiver>;

export class AsrStreamInputPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<AsrStreamInput> {

  handle: mojo.internal.interfaceSupport.Endpoint<AsrStreamInputPendingReceiver>;
  constructor(handle: MojoHandle|AsrStreamInputPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.AsrStreamInput',
        scope);
  }
}

export interface AsrStreamInputInterface {
  addAudioChunk(data: AudioData): void;
}

export class AsrStreamInputRemote implements AsrStreamInputInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AsrStreamInputPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AsrStreamInputPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AsrStreamInputPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AsrStreamInputPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  addAudioChunk(
      data: AudioData): void {
    this.proxy.sendMessage(
        0,
        AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AsrStreamInput
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AsrStreamInputReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AsrStreamInputRemote, AsrStreamInputPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AsrStreamInputRemote, AsrStreamInputPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AsrStreamInputInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AsrStreamInputRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        impl.addAudioChunk.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AsrStreamInput {
  static get $interfaceName(): string {
    return "on_device_model.mojom.AsrStreamInput";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AsrStreamInputRemote {
    let remote = new AsrStreamInputRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the AsrStreamInput
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AsrStreamInputCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AsrStreamInputRemote, AsrStreamInputPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AsrStreamInputRemote, AsrStreamInputPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  addAudioChunk: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AsrStreamInputRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.addAudioChunk =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        this.addAudioChunk.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const AdaptationAssetsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LanguageDetectionResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SafetyInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ResponseChunkSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ResponseSummarySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LoadAdaptationParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CapabilitiesSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SessionParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const InputSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AppendOptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GenerateOptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SpeechRecognitionResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AsrStreamOptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DevicePerformanceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DeviceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const StreamingResponder_OnResponse_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const StreamingResponder_OnComplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ContextClient_OnComplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_Append_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_Generate_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_GetSizeInTokens_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_GetSizeInTokens_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_Score_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_Score_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_Clone_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_GetProbabilitiesBlocking_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_GetProbabilitiesBlocking_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_SetPriority_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Session_AsrStream_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModel_StartSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModel_ClassifyTextSafety_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModel_DetectLanguage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModel_DetectLanguage_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModel_LoadAdaptation_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModel_LoadAdaptation_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextSafetySession_ClassifyTextSafety_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextSafetySession_ClassifyTextSafety_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextSafetySession_DetectLanguage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextSafetySession_DetectLanguage_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextSafetySession_Clone_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextSafetyModel_StartSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AsrStreamResponder_OnResponse_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AsrStreamInput_AddAudioChunk_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const InputPieceSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ResponseConstraintSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface AdaptationAssetsMojoType {
  weights: (mojoBase_mojom_File | null);
  weightsPath: (mojoBase_mojom_FilePath | null);
}


export type AdaptationAssets = AdaptationAssetsMojoType;
mojo.internal.Struct<AdaptationAssetsMojoType>(
    AdaptationAssetsSpec.$,
    'AdaptationAssets',
    [
      mojo.internal.StructField<AdaptationAssetsMojoType, mojoBase_mojom_File>(
        'weights', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdaptationAssetsMojoType, mojoBase_mojom_FilePath>(
        'weightsPath', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LanguageDetectionResultMojoType {
  code: string;
  reliability: number;
}


export type LanguageDetectionResult = LanguageDetectionResultMojoType;
mojo.internal.Struct<LanguageDetectionResultMojoType>(
    LanguageDetectionResultSpec.$,
    'LanguageDetectionResult',
    [
      mojo.internal.StructField<LanguageDetectionResultMojoType, string>(
        'code', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LanguageDetectionResultMojoType, number>(
        'reliability', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SafetyInfoMojoType {
  classScores: number[];
  language: (LanguageDetectionResult | null);
}


export type SafetyInfo = SafetyInfoMojoType;
mojo.internal.Struct<SafetyInfoMojoType>(
    SafetyInfoSpec.$,
    'SafetyInfo',
    [
      mojo.internal.StructField<SafetyInfoMojoType, number[]>(
        'classScores', 0,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SafetyInfoMojoType, LanguageDetectionResult>(
        'language', 8,
        0,
        LanguageDetectionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ResponseChunkMojoType {
  text: string;
  safetyInfo: (SafetyInfo | null);
}


export type ResponseChunk = ResponseChunkMojoType;
mojo.internal.Struct<ResponseChunkMojoType>(
    ResponseChunkSpec.$,
    'ResponseChunk',
    [
      mojo.internal.StructField<ResponseChunkMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ResponseChunkMojoType, SafetyInfo>(
        'safetyInfo', 8,
        0,
        SafetyInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ResponseSummaryMojoType {
  safetyInfo: (SafetyInfo | null);
  outputTokenCount: number;
}


export type ResponseSummary = ResponseSummaryMojoType;
mojo.internal.Struct<ResponseSummaryMojoType>(
    ResponseSummarySpec.$,
    'ResponseSummary',
    [
      mojo.internal.StructField<ResponseSummaryMojoType, SafetyInfo>(
        'safetyInfo', 0,
        0,
        SafetyInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ResponseSummaryMojoType, number>(
        'outputTokenCount', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LoadAdaptationParamsMojoType {
  assets: AdaptationAssets;
}


export type LoadAdaptationParams = LoadAdaptationParamsMojoType;
mojo.internal.Struct<LoadAdaptationParamsMojoType>(
    LoadAdaptationParamsSpec.$,
    'LoadAdaptationParams',
    [
      mojo.internal.StructField<LoadAdaptationParamsMojoType, AdaptationAssets>(
        'assets', 0,
        0,
        AdaptationAssetsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CapabilitiesMojoType {
  imageInput: boolean;
  audioInput: boolean;
}


export type Capabilities = CapabilitiesMojoType;
mojo.internal.Struct<CapabilitiesMojoType>(
    CapabilitiesSpec.$,
    'Capabilities',
    [
      mojo.internal.StructField<CapabilitiesMojoType, boolean>(
        'imageInput', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CapabilitiesMojoType, boolean>(
        'audioInput', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface SessionParamsMojoType {
  maxTokens: number;
  topK: number;
  capabilities: Capabilities;
  temperature: number;
}


export type SessionParams = SessionParamsMojoType;
mojo.internal.Struct<SessionParamsMojoType>(
    SessionParamsSpec.$,
    'SessionParams',
    [
      mojo.internal.StructField<SessionParamsMojoType, number>(
        'maxTokens', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SessionParamsMojoType, Capabilities>(
        'capabilities', 8,
        0,
        CapabilitiesSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SessionParamsMojoType, number>(
        'topK', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        1,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SessionParamsMojoType, number>(
        'temperature', 16,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        1,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],[1, 32],]);





export interface InputMojoType {
  pieces: InputPiece[];
}


export type Input = InputMojoType;
mojo.internal.Struct<InputMojoType>(
    InputSpec.$,
    'Input',
    [
      mojo.internal.StructField<InputMojoType, InputPiece[]>(
        'pieces', 0,
        0,
        mojo.internal.Array(InputPieceSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AppendOptionsMojoType {
  input: Input;
  maxTokens: number;
}


export type AppendOptions = AppendOptionsMojoType;
mojo.internal.Struct<AppendOptionsMojoType>(
    AppendOptionsSpec.$,
    'AppendOptions',
    [
      mojo.internal.StructField<AppendOptionsMojoType, Input>(
        'input', 0,
        0,
        InputSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppendOptionsMojoType, number>(
        'maxTokens', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface GenerateOptionsMojoType {
  maxOutputTokens: number;
  constraint: (ResponseConstraint | null);
}


export type GenerateOptions = GenerateOptionsMojoType;
mojo.internal.Struct<GenerateOptionsMojoType>(
    GenerateOptionsSpec.$,
    'GenerateOptions',
    [
      mojo.internal.StructField<GenerateOptionsMojoType, number>(
        'maxOutputTokens', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GenerateOptionsMojoType, ResponseConstraint>(
        'constraint', 8,
        0,
        ResponseConstraintSpec.$,
        null,
        true /* nullable */,
        2,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],[2, 32],]);





export interface AudioDataMojoType {
  channelCount: number;
  sampleRate: number;
  frameCount: number;
  data: number[];
}


export type AudioData = AudioDataMojoType;
mojo.internal.Struct<AudioDataMojoType>(
    AudioDataSpec.$,
    'AudioData',
    [
      mojo.internal.StructField<AudioDataMojoType, number>(
        'channelCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioDataMojoType, number>(
        'sampleRate', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioDataMojoType, number>(
        'frameCount', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioDataMojoType, number[]>(
        'data', 16,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface SpeechRecognitionResultMojoType {
  transcript: string;
  isFinal: boolean;
}


export type SpeechRecognitionResult = SpeechRecognitionResultMojoType;
mojo.internal.Struct<SpeechRecognitionResultMojoType>(
    SpeechRecognitionResultSpec.$,
    'SpeechRecognitionResult',
    [
      mojo.internal.StructField<SpeechRecognitionResultMojoType, string>(
        'transcript', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SpeechRecognitionResultMojoType, boolean>(
        'isFinal', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AsrStreamOptionsMojoType {
  sampleRateHz: number;
}


export type AsrStreamOptions = AsrStreamOptionsMojoType;
mojo.internal.Struct<AsrStreamOptionsMojoType>(
    AsrStreamOptionsSpec.$,
    'AsrStreamOptions',
    [
      mojo.internal.StructField<AsrStreamOptionsMojoType, number>(
        'sampleRateHz', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DevicePerformanceInfoMojoType {
  performanceClass: PerformanceClass;
  vramMb: bigint;
}


export type DevicePerformanceInfo = DevicePerformanceInfoMojoType;
mojo.internal.Struct<DevicePerformanceInfoMojoType>(
    DevicePerformanceInfoSpec.$,
    'DevicePerformanceInfo',
    [
      mojo.internal.StructField<DevicePerformanceInfoMojoType, PerformanceClass>(
        'performanceClass', 0,
        0,
        PerformanceClassSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DevicePerformanceInfoMojoType, bigint>(
        'vramMb', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface DeviceInfoMojoType {
  vendorId: number;
  deviceId: number;
  driverVersion: string;
  supportsFp16: boolean;
}


export type DeviceInfo = DeviceInfoMojoType;
mojo.internal.Struct<DeviceInfoMojoType>(
    DeviceInfoSpec.$,
    'DeviceInfo',
    [
      mojo.internal.StructField<DeviceInfoMojoType, number>(
        'vendorId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, number>(
        'deviceId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, string>(
        'driverVersion', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, boolean>(
        'supportsFp16', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface StreamingResponder_OnResponse_ParamsMojoType {
  chunk: ResponseChunk;
}


export type StreamingResponder_OnResponse_Params = StreamingResponder_OnResponse_ParamsMojoType;
mojo.internal.Struct<StreamingResponder_OnResponse_ParamsMojoType>(
    StreamingResponder_OnResponse_ParamsSpec.$,
    'StreamingResponder_OnResponse_Params',
    [
      mojo.internal.StructField<StreamingResponder_OnResponse_ParamsMojoType, ResponseChunk>(
        'chunk', 0,
        0,
        ResponseChunkSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface StreamingResponder_OnComplete_ParamsMojoType {
  summary: ResponseSummary;
}


export type StreamingResponder_OnComplete_Params = StreamingResponder_OnComplete_ParamsMojoType;
mojo.internal.Struct<StreamingResponder_OnComplete_ParamsMojoType>(
    StreamingResponder_OnComplete_ParamsSpec.$,
    'StreamingResponder_OnComplete_Params',
    [
      mojo.internal.StructField<StreamingResponder_OnComplete_ParamsMojoType, ResponseSummary>(
        'summary', 0,
        0,
        ResponseSummarySpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ContextClient_OnComplete_ParamsMojoType {
  tokensProcessed: number;
}


export type ContextClient_OnComplete_Params = ContextClient_OnComplete_ParamsMojoType;
mojo.internal.Struct<ContextClient_OnComplete_ParamsMojoType>(
    ContextClient_OnComplete_ParamsSpec.$,
    'ContextClient_OnComplete_Params',
    [
      mojo.internal.StructField<ContextClient_OnComplete_ParamsMojoType, number>(
        'tokensProcessed', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_Append_ParamsMojoType {
  options: AppendOptions;
  client: (ContextClientRemote | null);
}


export type Session_Append_Params = Session_Append_ParamsMojoType;
mojo.internal.Struct<Session_Append_ParamsMojoType>(
    Session_Append_ParamsSpec.$,
    'Session_Append_Params',
    [
      mojo.internal.StructField<Session_Append_ParamsMojoType, AppendOptions>(
        'options', 0,
        0,
        AppendOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Session_Append_ParamsMojoType, ContextClientRemote>(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(ContextClientRemote),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Session_Generate_ParamsMojoType {
  options: GenerateOptions;
  responder: StreamingResponderRemote;
}


export type Session_Generate_Params = Session_Generate_ParamsMojoType;
mojo.internal.Struct<Session_Generate_ParamsMojoType>(
    Session_Generate_ParamsSpec.$,
    'Session_Generate_Params',
    [
      mojo.internal.StructField<Session_Generate_ParamsMojoType, GenerateOptions>(
        'options', 0,
        0,
        GenerateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Session_Generate_ParamsMojoType, StreamingResponderRemote>(
        'responder', 8,
        0,
        mojo.internal.InterfaceProxy(StreamingResponderRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Session_GetSizeInTokens_ParamsMojoType {
  input: Input;
}


export type Session_GetSizeInTokens_Params = Session_GetSizeInTokens_ParamsMojoType;
mojo.internal.Struct<Session_GetSizeInTokens_ParamsMojoType>(
    Session_GetSizeInTokens_ParamsSpec.$,
    'Session_GetSizeInTokens_Params',
    [
      mojo.internal.StructField<Session_GetSizeInTokens_ParamsMojoType, Input>(
        'input', 0,
        0,
        InputSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_GetSizeInTokens_ResponseParamsMojoType {
  size: number;
}


export type Session_GetSizeInTokens_ResponseParams = Session_GetSizeInTokens_ResponseParamsMojoType;
mojo.internal.Struct<Session_GetSizeInTokens_ResponseParamsMojoType>(
    Session_GetSizeInTokens_ResponseParamsSpec.$,
    'Session_GetSizeInTokens_ResponseParams',
    [
      mojo.internal.StructField<Session_GetSizeInTokens_ResponseParamsMojoType, number>(
        'size', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_Score_ParamsMojoType {
  text: string;
}


export type Session_Score_Params = Session_Score_ParamsMojoType;
mojo.internal.Struct<Session_Score_ParamsMojoType>(
    Session_Score_ParamsSpec.$,
    'Session_Score_Params',
    [
      mojo.internal.StructField<Session_Score_ParamsMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_Score_ResponseParamsMojoType {
  probability: number;
}


export type Session_Score_ResponseParams = Session_Score_ResponseParamsMojoType;
mojo.internal.Struct<Session_Score_ResponseParamsMojoType>(
    Session_Score_ResponseParamsSpec.$,
    'Session_Score_ResponseParams',
    [
      mojo.internal.StructField<Session_Score_ResponseParamsMojoType, number>(
        'probability', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_Clone_ParamsMojoType {
  session: SessionPendingReceiver;
}


export type Session_Clone_Params = Session_Clone_ParamsMojoType;
mojo.internal.Struct<Session_Clone_ParamsMojoType>(
    Session_Clone_ParamsSpec.$,
    'Session_Clone_Params',
    [
      mojo.internal.StructField<Session_Clone_ParamsMojoType, SessionPendingReceiver>(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(SessionPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_GetProbabilitiesBlocking_ParamsMojoType {
  text: string;
}


export type Session_GetProbabilitiesBlocking_Params = Session_GetProbabilitiesBlocking_ParamsMojoType;
mojo.internal.Struct<Session_GetProbabilitiesBlocking_ParamsMojoType>(
    Session_GetProbabilitiesBlocking_ParamsSpec.$,
    'Session_GetProbabilitiesBlocking_Params',
    [
      mojo.internal.StructField<Session_GetProbabilitiesBlocking_ParamsMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_GetProbabilitiesBlocking_ResponseParamsMojoType {
  probabilities: number[];
}


export type Session_GetProbabilitiesBlocking_ResponseParams = Session_GetProbabilitiesBlocking_ResponseParamsMojoType;
mojo.internal.Struct<Session_GetProbabilitiesBlocking_ResponseParamsMojoType>(
    Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
    'Session_GetProbabilitiesBlocking_ResponseParams',
    [
      mojo.internal.StructField<Session_GetProbabilitiesBlocking_ResponseParamsMojoType, number[]>(
        'probabilities', 0,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_SetPriority_ParamsMojoType {
  priority: Priority;
}


export type Session_SetPriority_Params = Session_SetPriority_ParamsMojoType;
mojo.internal.Struct<Session_SetPriority_ParamsMojoType>(
    Session_SetPriority_ParamsSpec.$,
    'Session_SetPriority_Params',
    [
      mojo.internal.StructField<Session_SetPriority_ParamsMojoType, Priority>(
        'priority', 0,
        0,
        PrioritySpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Session_AsrStream_ParamsMojoType {
  options: AsrStreamOptions;
  stream: AsrStreamInputPendingReceiver;
  responder: AsrStreamResponderRemote;
}


export type Session_AsrStream_Params = Session_AsrStream_ParamsMojoType;
mojo.internal.Struct<Session_AsrStream_ParamsMojoType>(
    Session_AsrStream_ParamsSpec.$,
    'Session_AsrStream_Params',
    [
      mojo.internal.StructField<Session_AsrStream_ParamsMojoType, AsrStreamOptions>(
        'options', 0,
        0,
        AsrStreamOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Session_AsrStream_ParamsMojoType, AsrStreamInputPendingReceiver>(
        'stream', 8,
        0,
        mojo.internal.InterfaceRequest(AsrStreamInputPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Session_AsrStream_ParamsMojoType, AsrStreamResponderRemote>(
        'responder', 12,
        0,
        mojo.internal.InterfaceProxy(AsrStreamResponderRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface OnDeviceModel_StartSession_ParamsMojoType {
  session: SessionPendingReceiver;
  params: (SessionParams | null);
}


export type OnDeviceModel_StartSession_Params = OnDeviceModel_StartSession_ParamsMojoType;
mojo.internal.Struct<OnDeviceModel_StartSession_ParamsMojoType>(
    OnDeviceModel_StartSession_ParamsSpec.$,
    'OnDeviceModel_StartSession_Params',
    [
      mojo.internal.StructField<OnDeviceModel_StartSession_ParamsMojoType, SessionPendingReceiver>(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(SessionPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModel_StartSession_ParamsMojoType, SessionParams>(
        'params', 8,
        0,
        SessionParamsSpec.$,
        null,
        true /* nullable */,
        1,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],[1, 24],]);





export interface OnDeviceModel_ClassifyTextSafety_ParamsMojoType {
  text: string;
}


export type OnDeviceModel_ClassifyTextSafety_Params = OnDeviceModel_ClassifyTextSafety_ParamsMojoType;
mojo.internal.Struct<OnDeviceModel_ClassifyTextSafety_ParamsMojoType>(
    OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
    'OnDeviceModel_ClassifyTextSafety_Params',
    [
      mojo.internal.StructField<OnDeviceModel_ClassifyTextSafety_ParamsMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModel_ClassifyTextSafety_ResponseParamsMojoType {
  safetyInfo: (SafetyInfo | null);
}


export type OnDeviceModel_ClassifyTextSafety_ResponseParams = OnDeviceModel_ClassifyTextSafety_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModel_ClassifyTextSafety_ResponseParamsMojoType>(
    OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
    'OnDeviceModel_ClassifyTextSafety_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModel_ClassifyTextSafety_ResponseParamsMojoType, SafetyInfo>(
        'safetyInfo', 0,
        0,
        SafetyInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModel_DetectLanguage_ParamsMojoType {
  text: string;
}


export type OnDeviceModel_DetectLanguage_Params = OnDeviceModel_DetectLanguage_ParamsMojoType;
mojo.internal.Struct<OnDeviceModel_DetectLanguage_ParamsMojoType>(
    OnDeviceModel_DetectLanguage_ParamsSpec.$,
    'OnDeviceModel_DetectLanguage_Params',
    [
      mojo.internal.StructField<OnDeviceModel_DetectLanguage_ParamsMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModel_DetectLanguage_ResponseParamsMojoType {
  result: (LanguageDetectionResult | null);
}


export type OnDeviceModel_DetectLanguage_ResponseParams = OnDeviceModel_DetectLanguage_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModel_DetectLanguage_ResponseParamsMojoType>(
    OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
    'OnDeviceModel_DetectLanguage_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModel_DetectLanguage_ResponseParamsMojoType, LanguageDetectionResult>(
        'result', 0,
        0,
        LanguageDetectionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModel_LoadAdaptation_ParamsMojoType {
  params: LoadAdaptationParams;
  model: OnDeviceModelPendingReceiver;
}


export type OnDeviceModel_LoadAdaptation_Params = OnDeviceModel_LoadAdaptation_ParamsMojoType;
mojo.internal.Struct<OnDeviceModel_LoadAdaptation_ParamsMojoType>(
    OnDeviceModel_LoadAdaptation_ParamsSpec.$,
    'OnDeviceModel_LoadAdaptation_Params',
    [
      mojo.internal.StructField<OnDeviceModel_LoadAdaptation_ParamsMojoType, LoadAdaptationParams>(
        'params', 0,
        0,
        LoadAdaptationParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModel_LoadAdaptation_ParamsMojoType, OnDeviceModelPendingReceiver>(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(OnDeviceModelPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OnDeviceModel_LoadAdaptation_ResponseParamsMojoType {
  result: LoadModelResult;
}


export type OnDeviceModel_LoadAdaptation_ResponseParams = OnDeviceModel_LoadAdaptation_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModel_LoadAdaptation_ResponseParamsMojoType>(
    OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
    'OnDeviceModel_LoadAdaptation_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModel_LoadAdaptation_ResponseParamsMojoType, LoadModelResult>(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TextSafetySession_ClassifyTextSafety_ParamsMojoType {
  text: string;
}


export type TextSafetySession_ClassifyTextSafety_Params = TextSafetySession_ClassifyTextSafety_ParamsMojoType;
mojo.internal.Struct<TextSafetySession_ClassifyTextSafety_ParamsMojoType>(
    TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
    'TextSafetySession_ClassifyTextSafety_Params',
    [
      mojo.internal.StructField<TextSafetySession_ClassifyTextSafety_ParamsMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TextSafetySession_ClassifyTextSafety_ResponseParamsMojoType {
  safetyInfo: (SafetyInfo | null);
}


export type TextSafetySession_ClassifyTextSafety_ResponseParams = TextSafetySession_ClassifyTextSafety_ResponseParamsMojoType;
mojo.internal.Struct<TextSafetySession_ClassifyTextSafety_ResponseParamsMojoType>(
    TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
    'TextSafetySession_ClassifyTextSafety_ResponseParams',
    [
      mojo.internal.StructField<TextSafetySession_ClassifyTextSafety_ResponseParamsMojoType, SafetyInfo>(
        'safetyInfo', 0,
        0,
        SafetyInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TextSafetySession_DetectLanguage_ParamsMojoType {
  text: string;
}


export type TextSafetySession_DetectLanguage_Params = TextSafetySession_DetectLanguage_ParamsMojoType;
mojo.internal.Struct<TextSafetySession_DetectLanguage_ParamsMojoType>(
    TextSafetySession_DetectLanguage_ParamsSpec.$,
    'TextSafetySession_DetectLanguage_Params',
    [
      mojo.internal.StructField<TextSafetySession_DetectLanguage_ParamsMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TextSafetySession_DetectLanguage_ResponseParamsMojoType {
  result: (LanguageDetectionResult | null);
}


export type TextSafetySession_DetectLanguage_ResponseParams = TextSafetySession_DetectLanguage_ResponseParamsMojoType;
mojo.internal.Struct<TextSafetySession_DetectLanguage_ResponseParamsMojoType>(
    TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
    'TextSafetySession_DetectLanguage_ResponseParams',
    [
      mojo.internal.StructField<TextSafetySession_DetectLanguage_ResponseParamsMojoType, LanguageDetectionResult>(
        'result', 0,
        0,
        LanguageDetectionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TextSafetySession_Clone_ParamsMojoType {
  session: TextSafetySessionPendingReceiver;
}


export type TextSafetySession_Clone_Params = TextSafetySession_Clone_ParamsMojoType;
mojo.internal.Struct<TextSafetySession_Clone_ParamsMojoType>(
    TextSafetySession_Clone_ParamsSpec.$,
    'TextSafetySession_Clone_Params',
    [
      mojo.internal.StructField<TextSafetySession_Clone_ParamsMojoType, TextSafetySessionPendingReceiver>(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(TextSafetySessionPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TextSafetyModel_StartSession_ParamsMojoType {
  session: TextSafetySessionPendingReceiver;
}


export type TextSafetyModel_StartSession_Params = TextSafetyModel_StartSession_ParamsMojoType;
mojo.internal.Struct<TextSafetyModel_StartSession_ParamsMojoType>(
    TextSafetyModel_StartSession_ParamsSpec.$,
    'TextSafetyModel_StartSession_Params',
    [
      mojo.internal.StructField<TextSafetyModel_StartSession_ParamsMojoType, TextSafetySessionPendingReceiver>(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(TextSafetySessionPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AsrStreamResponder_OnResponse_ParamsMojoType {
  result: SpeechRecognitionResult[];
}


export type AsrStreamResponder_OnResponse_Params = AsrStreamResponder_OnResponse_ParamsMojoType;
mojo.internal.Struct<AsrStreamResponder_OnResponse_ParamsMojoType>(
    AsrStreamResponder_OnResponse_ParamsSpec.$,
    'AsrStreamResponder_OnResponse_Params',
    [
      mojo.internal.StructField<AsrStreamResponder_OnResponse_ParamsMojoType, SpeechRecognitionResult[]>(
        'result', 0,
        0,
        mojo.internal.Array(SpeechRecognitionResultSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AsrStreamInput_AddAudioChunk_ParamsMojoType {
  data: AudioData;
}


export type AsrStreamInput_AddAudioChunk_Params = AsrStreamInput_AddAudioChunk_ParamsMojoType;
mojo.internal.Struct<AsrStreamInput_AddAudioChunk_ParamsMojoType>(
    AsrStreamInput_AddAudioChunk_ParamsSpec.$,
    'AsrStreamInput_AddAudioChunk_Params',
    [
      mojo.internal.StructField<AsrStreamInput_AddAudioChunk_ParamsMojoType, AudioData>(
        'data', 0,
        0,
        AudioDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    InputPieceSpec.$, 'InputPiece',
    {
      'token': {
        'ordinal': 0,
        'type': TokenSpec.$,
      },
      'text': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'bitmap': {
        'ordinal': 2,
        'type': skia_mojom_BitmapWithArbitraryBppSpec.$,
      },
      'unknownType': {
        'ordinal': 3,
        'type': mojo.internal.Bool,
      },
      'audio': {
        'ordinal': 4,
        'type': AudioDataSpec.$,
      },
    });

export interface InputPiece {
  token?: Token,
  text?: string,
  bitmap?: skia_mojom_BitmapWithArbitraryBpp,
  unknownType?: boolean,
  audio?: AudioData,
}

export enum InputPieceFieldTags {
  TOKEN,
  TEXT,
  BITMAP,
  UNKNOWN_TYPE,
  AUDIO,
}

export function whichInputPiece(u: InputPiece): InputPieceFieldTags {
  if (u.token !== null && u.token !== undefined) {
    return InputPieceFieldTags.TOKEN;
  }
  if (u.text !== null && u.text !== undefined) {
    return InputPieceFieldTags.TEXT;
  }
  if (u.bitmap !== null && u.bitmap !== undefined) {
    return InputPieceFieldTags.BITMAP;
  }
  if (u.unknownType !== null && u.unknownType !== undefined) {
    return InputPieceFieldTags.UNKNOWN_TYPE;
  }
  if (u.audio !== null && u.audio !== undefined) {
    return InputPieceFieldTags.AUDIO;
  }
  return InputPieceFieldTags.UNKNOWN_TYPE;
}
mojo.internal.Union(
    ResponseConstraintSpec.$, 'ResponseConstraint',
    {
      'jsonSchema': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'regex': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'unknownType': {
        'ordinal': 2,
        'type': mojo.internal.Bool,
      },
    });

export interface ResponseConstraint {
  jsonSchema?: string,
  regex?: string,
  unknownType?: boolean,
}

export enum ResponseConstraintFieldTags {
  JSON_SCHEMA,
  REGEX,
  UNKNOWN_TYPE,
}

export function whichResponseConstraint(u: ResponseConstraint): ResponseConstraintFieldTags {
  if (u.jsonSchema !== null && u.jsonSchema !== undefined) {
    return ResponseConstraintFieldTags.JSON_SCHEMA;
  }
  if (u.regex !== null && u.regex !== undefined) {
    return ResponseConstraintFieldTags.REGEX;
  }
  if (u.unknownType !== null && u.unknownType !== undefined) {
    return ResponseConstraintFieldTags.UNKNOWN_TYPE;
  }
  return ResponseConstraintFieldTags.UNKNOWN_TYPE;
}
