// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_components/searchbox/searchbox.js';
import '/strings.m.js';
import { assert } from '//resources/js/assert.js';
import { EventTracker } from '//resources/js/event_tracker.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './full_app.css.js';
import { getHtml } from './full_app.html.js';
export class OmniboxFullAppElement extends CrLitElement {
    static get is() {
        return 'omnibox-full-app';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            omniboxPopupDebugEnabled_: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #omniboxPopupDebugEnabled__accessor_storage = loadTimeData.getBoolean('omniboxPopupDebugEnabled');
    get omniboxPopupDebugEnabled_() { return this.#omniboxPopupDebugEnabled__accessor_storage; }
    set omniboxPopupDebugEnabled_(value) { this.#omniboxPopupDebugEnabled__accessor_storage = value; }
    isDebug_ = new URLSearchParams(window.location.search).has('debug');
    eventTracker_ = new EventTracker();
    connectedCallback() {
        super.connectedCallback();
        this.eventTracker_.add(document.documentElement, 'visibilitychange', this.onVisibilitychange_.bind(this));
        this.onVisibilitychange_();
        if (!this.isDebug_) {
            this.eventTracker_.add(document.documentElement, 'contextmenu', (e) => {
                e.preventDefault();
            });
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.eventTracker_.removeAll();
    }
    onVisibilitychange_() {
        if (document.visibilityState !== 'visible') {
            return;
        }
        const searchbox = this.shadowRoot.querySelector('cr-searchbox');
        assert(searchbox);
        searchbox.focusInput();
    }
}
customElements.define(OmniboxFullAppElement.is, OmniboxFullAppElement);
